/*
 * Decompiled with CFR 0.152.
 */
package kieker.extension.cassandra.writer;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import com.datastax.driver.core.exceptions.QueryValidationException;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.extension.cassandra.CassandraValueSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDb {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraDb.class);
    private final List<InetSocketAddress> contactPoints;
    private final String keyspace;
    private final String tablePrefix;
    private final boolean dropTables;
    private final Map<Class<?>, String> databaseTypeMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends IMonitoringRecord>, PreparedStatement> classes = new ConcurrentHashMap();
    private Cluster cluster;
    private Session session;

    public CassandraDb(String keyspace, List<InetSocketAddress> contactPoints, String tablePrefix, boolean dropTables) {
        this.initializeDatabaseTypeMapping();
        this.keyspace = keyspace;
        this.tablePrefix = tablePrefix;
        this.dropTables = dropTables;
        this.contactPoints = contactPoints;
    }

    public boolean connect() {
        try {
            this.cluster = Cluster.builder().addContactPointsWithPorts(this.contactPoints).withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE).withMaxSchemaAgreementWaitSeconds(60).build();
            this.session = this.cluster.connect(this.keyspace);
            this.createIndexTable();
            return true;
        }
        catch (AuthenticationException | InvalidQueryException | NoHostAvailableException | IllegalStateException exc) {
            LOGGER.error("Opening Connection to Database failed. {}", (Object)exc.getLocalizedMessage());
            return false;
        }
    }

    public void disconnect() {
        this.session.close();
        this.cluster.close();
    }

    public void insert(IMonitoringRecord record, String benchmarkId) throws MonitoringRecordException {
        Class<?> recordClass = record.getClass();
        BoundStatement boundStatement = this.getBoundStatement(this.getPreparedStatement(recordClass, benchmarkId));
        CassandraValueSerializer cassandraSerializer = new CassandraValueSerializer(boundStatement);
        cassandraSerializer.putLong(record.getLoggingTimestamp());
        record.serialize(cassandraSerializer);
        this.session.execute((Statement)boundStatement);
    }

    private PreparedStatement getPreparedStatement(Class<? extends IMonitoringRecord> recordClass, String benchmarkId) throws MonitoringRecordException {
        PreparedStatement statement = this.classes.get(recordClass);
        if (statement == null) {
            statement = this.createRecordInsertStatement(recordClass.getSimpleName(), benchmarkId, recordClass);
            this.classes.put(recordClass, statement);
        }
        return statement;
    }

    private PreparedStatement createRecordInsertStatement(String className, String benchmarkId, Class<? extends IMonitoringRecord> recordClass) throws MonitoringRecordException {
        Class<?>[] typeArray = null;
        try {
            typeArray = AbstractMonitoringRecord.typesForClass(recordClass);
        }
        catch (MonitoringRecordException exc) {
            LOGGER.error("Failed to get types of record: {}", (Object)exc.getLocalizedMessage());
        }
        String tableName = this.createTable(className, typeArray);
        StringBuilder values = new StringBuilder();
        values.append("'" + benchmarkId + "',?");
        StringBuilder fields = new StringBuilder("benchmark_id,timestamp");
        for (int i = 1; i <= typeArray.length; ++i) {
            values.append(",?");
            fields.append(",c");
            fields.append(i);
        }
        return this.session.prepare(String.format("INSERT INTO %s ( %s )  VALUES (%s)", tableName, fields.toString(), values.toString()));
    }

    private void initializeDatabaseTypeMapping() {
        Class[] primitiveTypes = new Class[]{String.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class, Character.TYPE, Character.class};
        String[] databaseTypes = new String[]{"text", "int", "int", "bigint", "bigint", "float", "float", "double", "double", "int", "int", "boolean", "boolean", "varchar", "varchar"};
        for (int i = 0; i < primitiveTypes.length; ++i) {
            this.databaseTypeMap.put(primitiveTypes[i], databaseTypes[i]);
        }
    }

    private BoundStatement getBoundStatement(String statement) {
        return new BoundStatement(this.session.prepare(statement));
    }

    public BoundStatement getBoundStatement(PreparedStatement statement) {
        return new BoundStatement(statement);
    }

    private void createIndexTable() {
        if (this.dropTables) {
            this.dropTable(this.tablePrefix);
            this.createTableClassLookupTable();
        } else if (!this.doesTableExist(this.tablePrefix)) {
            this.createTableClassLookupTable();
        }
    }

    private void dropTable(String tableName) {
        String dropStatement = "DROP TABLE " + tableName;
        BoundStatement boundStatement = this.getBoundStatement(dropStatement);
        try {
            this.session.execute((Statement)boundStatement);
        }
        catch (NoHostAvailableException | QueryExecutionException | QueryValidationException | UnsupportedFeatureException exc) {
            LOGGER.warn("Dropping table {} failed.", (Object)tableName);
        }
    }

    private void createTableClassLookupTable() {
        String createStatement = String.format("CREATE TABLE %s ( tablename text, classname text, PRIMARY KEY (tablename) )", this.tablePrefix);
        BoundStatement boundStatement = this.getBoundStatement(createStatement);
        try {
            this.session.execute((Statement)boundStatement);
        }
        catch (NoHostAvailableException | QueryExecutionException | QueryValidationException | UnsupportedFeatureException exc) {
            LOGGER.error("Creating index table {} failed!", (Object)this.tablePrefix);
        }
    }

    private boolean doesTableExist(String tableName) {
        String selectStatement = "SELECT * FROM " + tableName;
        BoundStatement boundStatement = this.getBoundStatement(selectStatement);
        try {
            return this.session.execute((Statement)boundStatement) != null;
        }
        catch (NoHostAvailableException | QueryExecutionException | QueryValidationException | UnsupportedFeatureException exc) {
            return false;
        }
    }

    private String createTable(String className, Class<?> ... columns) throws MonitoringRecordException {
        String tableName = this.createTableName(className);
        if (this.dropTables) {
            this.dropTable(tableName);
            this.createClassTable(tableName, className, columns);
        } else if (!this.doesTableExist(tableName)) {
            this.createClassTable(tableName, className, columns);
        }
        return tableName;
    }

    private String createTableName(String className) {
        return this.tablePrefix + "_" + className;
    }

    private void createClassTable(String tableName, String className, Class<?>[] attributeTypes) throws MonitoringRecordException {
        BoundStatement boundStatement = this.getBoundStatement(this.createClassTableString(tableName, attributeTypes));
        try {
            this.session.execute((Statement)boundStatement);
        }
        catch (NoHostAvailableException | QueryExecutionException | QueryValidationException | UnsupportedFeatureException exc) {
            throw new MonitoringRecordException(String.format("Creating table %s failed!", tableName), exc);
        }
        String addIndex = String.format("INSERT INTO %s (tablename, classname) VALUES('%s','%s')", this.tablePrefix, tableName, className);
        BoundStatement index = this.getBoundStatement(addIndex);
        try {
            this.session.execute((Statement)index);
        }
        catch (NoHostAvailableException | QueryExecutionException | QueryValidationException | UnsupportedFeatureException exc) {
            throw new MonitoringRecordException(String.format("Adding table %s to index failed!", tableName), exc);
        }
    }

    private String createClassTableString(String tableName, Class<?>[] attributeTypes) throws MonitoringRecordException {
        StringBuilder createTable = new StringBuilder(100);
        createTable.append(String.format("CREATE TABLE %s (benchmark_id %s, timestamp %s", tableName, this.databaseTypeMap.get(String.class), this.databaseTypeMap.get(Long.TYPE)));
        int i = 0;
        for (Class<?> c : attributeTypes) {
            createTable.append(", c").append(i++).append(' ');
            String databaseType = this.databaseTypeMap.get(c);
            if (databaseType == null) {
                throw new MonitoringRecordException(String.format("Type '%s' not supported.", c.getSimpleName()));
            }
            createTable.append(databaseType);
        }
        createTable.append(", PRIMARY KEY (benchmark_id, timestamp)) ");
        return createTable.toString();
    }
}

