/*
 * Decompiled with CFR 0.152.
 */
package kieker.extension.cassandra.writer;

import kieker.common.configuration.Configuration;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.record.IMonitoringRecord;
import kieker.extension.cassandra.CassandraUtils;
import kieker.extension.cassandra.writer.CassandraDb;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDbWriter
extends AbstractMonitoringWriter {
    private static final String PREFIX = CassandraDbWriter.class.getName() + ".";
    public static final String CONFIG_KEYSPACE = PREFIX + "keyspace";
    public static final String CONFIG_CONTACTPOINTS = PREFIX + "contactpoints";
    public static final String CONFIG_TABLE_PREFIX = PREFIX + "tablePrefix";
    public static final String CONFIG_OVERWRITE = PREFIX + "dropTables";
    public static final String CONFIG_BENCHMARK_ID = PREFIX + "benchmarkId";
    private static final String DEFAULT_KEYSPACE = "kieker";
    private static final String DEFAULT_TABLE_PREFIX = "kieker";
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraDbWriter.class);
    private final CassandraDb database;
    private final String benchmarkId;

    public CassandraDbWriter(Configuration configuration) {
        super(configuration);
        String keyspace = configuration.getStringProperty(CONFIG_KEYSPACE, "kieker");
        String[] contactPointParameters = configuration.getStringArrayProperty(CONFIG_CONTACTPOINTS, ",");
        String tablePrefix = configuration.getStringProperty(CONFIG_TABLE_PREFIX, "kieker");
        boolean dropTables = configuration.getBooleanProperty(CONFIG_OVERWRITE);
        this.benchmarkId = configuration.getStringProperty(CONFIG_BENCHMARK_ID);
        this.database = new CassandraDb(keyspace, CassandraUtils.computeDatabaseConnections(contactPointParameters), tablePrefix, dropTables);
    }

    @Override
    public void onStarting() {
        this.database.connect();
    }

    @Override
    public void writeMonitoringRecord(IMonitoringRecord record) {
        try {
            this.database.insert(record, this.benchmarkId);
        }
        catch (MonitoringRecordException e) {
            LOGGER.error("Error inserting monitoring record: {}", (Object)e.getLocalizedMessage());
        }
    }

    @Override
    public void onTerminating() {
        this.database.disconnect();
    }
}

