/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.listener;

import java.util.Arrays;
import java.util.LinkedList;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.IRecordReceivedListener;
import kieker.common.record.remotecontrol.ActivationEvent;
import kieker.common.record.remotecontrol.ActivationParameterEvent;
import kieker.common.record.remotecontrol.AddParameterValueEvent;
import kieker.common.record.remotecontrol.DeactivationEvent;
import kieker.common.record.remotecontrol.IRemoteControlEvent;
import kieker.common.record.remotecontrol.IRemoteParameterControlEvent;
import kieker.common.record.remotecontrol.RemoveParameterValueEvent;
import kieker.common.record.remotecontrol.UpdateParameterEvent;
import kieker.monitoring.core.controller.MonitoringController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringCommandListener
implements IRecordReceivedListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringCommandListener.class);
    private final MonitoringController monitoringController;

    public MonitoringCommandListener(MonitoringController monitoringController) {
        this.monitoringController = monitoringController;
    }

    @Override
    public void onRecordReceived(IMonitoringRecord record) {
        LOGGER.debug("Received new record: {}", (Object)record.getClass().getName());
        if (!(record instanceof IRemoteControlEvent)) {
            LOGGER.info("Received an event for the TCP monitoring controller, which is no remote control event");
        }
        String pattern = ((IRemoteControlEvent)record).getPattern();
        if (record instanceof DeactivationEvent) {
            this.monitoringController.deactivateProbe(pattern);
            this.monitoringController.clearPatternParameters(pattern);
        } else if (record instanceof ActivationParameterEvent) {
            IRemoteParameterControlEvent event = (IRemoteParameterControlEvent)record;
            this.monitoringController.addPatternParameter(pattern, event.getName(), new LinkedList<String>(Arrays.asList(event.getValues())));
            this.monitoringController.activateProbe(pattern);
        } else if (record instanceof ActivationEvent) {
            this.monitoringController.clearPatternParameters(pattern);
            this.monitoringController.activateProbe(pattern);
        } else if (record instanceof AddParameterValueEvent) {
            AddParameterValueEvent event = (AddParameterValueEvent)record;
            this.monitoringController.addPatternParameterValue(pattern, event.getName(), event.getValue());
        } else if (record instanceof RemoveParameterValueEvent) {
            RemoveParameterValueEvent event = (RemoveParameterValueEvent)record;
            this.monitoringController.removePatternParameterValue(pattern, event.getName(), event.getValue());
        } else if (record instanceof UpdateParameterEvent) {
            IRemoteParameterControlEvent event = (IRemoteParameterControlEvent)record;
            this.monitoringController.addPatternParameter(pattern, event.getName(), new LinkedList<String>(Arrays.asList(event.getValues())));
        } else {
            LOGGER.info("Received unknown remote control event: {}", (Object)record.getClass().getName());
        }
    }
}

