/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.flow.constructorExecutionObjectInterface;

import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.constructor.object.AfterConstructorFailedObjectEvent;
import kieker.common.record.flow.trace.operation.constructor.object.AfterConstructorObjectEvent;
import kieker.common.record.flow.trace.operation.constructor.object.BeforeConstructorObjectInterfaceEvent;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.TraceRegistry;
import kieker.monitoring.probe.aspectj.AbstractAspectJProbe;
import kieker.monitoring.probe.aspectj.beforeafter.onlycallee.Counter;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public abstract class AbstractAspect
extends AbstractAspectJProbe {
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final TraceRegistry TRACEREGISTRY = TraceRegistry.INSTANCE;
    private final ThreadLocal<Counter> currentStackIndex = new ThreadLocal<Counter>(){

        @Override
        protected Counter initialValue() {
            return new Counter();
        }
    };

    @Pointcut
    public abstract void monitoredConstructor();

    @Before(value="monitoredConstructor() && this(thisObject) && notWithinKieker()")
    public void beforeConstructor(Object thisObject, JoinPoint thisJoinPoint) throws Throwable {
        boolean newTrace;
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(thisJoinPoint.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        boolean bl = newTrace = trace == null;
        if (newTrace) {
            trace = TRACEREGISTRY.registerTrace();
            CTRLINST.newMonitoringRecord(trace);
        }
        this.currentStackIndex.get().incrementValue();
        long traceId = trace.getTraceId();
        String clazz = thisJoinPoint.getSignature().getDeclaringTypeName();
        int objectId = System.identityHashCode(thisObject);
        CTRLINST.newMonitoringRecord(new BeforeConstructorObjectInterfaceEvent(TIME.getTime(), traceId, trace.getNextOrderId(), operationSignature, clazz, objectId, AbstractAspect.getInterface(thisJoinPoint)));
    }

    @AfterReturning(value="monitoredConstructor() && this(thisObject) && notWithinKieker()")
    public void afterConstructor(Object thisObject, JoinPoint thisJoinPoint) throws Throwable {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(thisJoinPoint.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        long traceId = trace.getTraceId();
        String clazz = thisJoinPoint.getSignature().getDeclaringTypeName();
        int objectId = System.identityHashCode(thisObject);
        CTRLINST.newMonitoringRecord(new AfterConstructorObjectEvent(TIME.getTime(), traceId, trace.getNextOrderId(), operationSignature, clazz, objectId));
    }

    @AfterThrowing(pointcut="monitoredConstructor() && this(thisObject) && notWithinKieker()", throwing="th")
    public void afterConstructorThrowing(Object thisObject, JoinPoint thisJoinPoint, Throwable th) throws Throwable {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(thisJoinPoint.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        long traceId = trace.getTraceId();
        String clazz = thisJoinPoint.getSignature().getDeclaringTypeName();
        int objectId = System.identityHashCode(thisObject);
        CTRLINST.newMonitoringRecord(new AfterConstructorFailedObjectEvent(TIME.getTime(), traceId, trace.getNextOrderId(), operationSignature, clazz, th.toString(), objectId));
    }

    @After(value="monitoredConstructor() && notWithinKieker()")
    public void afterOperation(JoinPoint thisJoinPoint) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(thisJoinPoint.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        int stackIndex = this.currentStackIndex.get().decrementValue();
        if (stackIndex == 1) {
            TRACEREGISTRY.unregisterTrace();
        }
    }

    private static final String getInterface(JoinPoint thisJoinPoint) {
        Class<?>[] interfaces = thisJoinPoint.getSignature().getDeclaringType().getInterfaces();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (interfaces.length == 0) {
            String superClassName;
            Class superClass = thisJoinPoint.getSignature().getDeclaringType().getSuperclass();
            if (superClass != null && !"java.lang.Object".equals(superClassName = superClass.getName())) {
                sb.append(superClassName);
            }
        } else {
            for (int idx = 0; idx < interfaces.length; ++idx) {
                sb.append(interfaces[idx].getName());
                if (idx >= interfaces.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

