/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.spring.flow;

import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.TraceRegistry;
import kieker.monitoring.probe.IMonitoringProbe;
import kieker.monitoring.timer.ITimeSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class OperationExecutionMethodInvocationInterceptor
implements MethodInterceptor,
IMonitoringProbe {
    private static final TraceRegistry TRACEREGISTRY = TraceRegistry.INSTANCE;
    private final IMonitoringController monitoringCtrl;
    private final ITimeSource timeSource;

    public OperationExecutionMethodInvocationInterceptor() {
        this(MonitoringController.getInstance());
    }

    public OperationExecutionMethodInvocationInterceptor(IMonitoringController monitoringController) {
        this.monitoringCtrl = monitoringController;
        this.timeSource = this.monitoringCtrl.getTimeSource();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object retval;
        boolean newTrace;
        if (!this.monitoringCtrl.isMonitoringEnabled()) {
            return invocation.proceed();
        }
        String signature = invocation.getMethod().toString();
        if (!this.monitoringCtrl.isProbeActivated(signature)) {
            return invocation.proceed();
        }
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        boolean bl = newTrace = trace == null;
        if (newTrace) {
            trace = TRACEREGISTRY.registerTrace();
            this.monitoringCtrl.newMonitoringRecord(trace);
        }
        long traceId = trace.getTraceId();
        String clazz = invocation.getThis().getClass().getName();
        this.monitoringCtrl.newMonitoringRecord(new BeforeOperationEvent(this.timeSource.getTime(), traceId, trace.getNextOrderId(), signature, clazz));
        try {
            retval = invocation.proceed();
        }
        catch (Throwable th) {
            this.monitoringCtrl.newMonitoringRecord(new AfterOperationFailedEvent(this.timeSource.getTime(), traceId, trace.getNextOrderId(), signature, clazz, th.toString()));
            throw th;
        }
        finally {
            if (newTrace) {
                TRACEREGISTRY.unregisterTrace();
            }
        }
        this.monitoringCtrl.newMonitoringRecord(new AfterOperationEvent(this.timeSource.getTime(), traceId, trace.getNextOrderId(), signature, clazz));
        return retval;
    }
}

