/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.queue.behavior;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import kieker.monitoring.queue.behavior.InsertBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountOnFailedInsertBehavior<E>
implements InsertBehavior<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CountOnFailedInsertBehavior.class);
    private final BlockingQueue<E> queue;
    private final AtomicLong numFailedInserts = new AtomicLong();

    public CountOnFailedInsertBehavior(BlockingQueue<E> queue) {
        this.queue = queue;
    }

    @Override
    public boolean insert(E element) {
        boolean offered = this.queue.offer(element);
        if (!offered) {
            long tmpMissedRecords = this.numFailedInserts.incrementAndGet();
            if (LOGGER.isWarnEnabled() && tmpMissedRecords % 1024L == 1L) {
                LOGGER.warn("Queue is full, dropping records. Number of already dropped records: " + tmpMissedRecords);
            }
        }
        return true;
    }

    public long getNumFailedInserts() {
        return this.numFailedInserts.get();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128).append(this.getClass()).append("\n\t\t").append("Number of failed inserts: ").append(this.getNumFailedInserts());
        return builder.toString();
    }
}

