/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.mxbean;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.jvm.GCRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.signaturePattern.SignatureFactory;
import kieker.monitoring.sampler.mxbean.AbstractMXBeanSampler;

public class GCSampler
extends AbstractMXBeanSampler {
    @Override
    protected IMonitoringRecord[] createNewMonitoringRecords(long timestamp, String hostname, String vmName, IMonitoringController monitoringCtr) {
        if (!monitoringCtr.isProbeActivated(SignatureFactory.createJVMGarbageCollectorSignature())) {
            return new IMonitoringRecord[0];
        }
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        int numberOfGCs = gcBeans.size();
        IMonitoringRecord[] records = new IMonitoringRecord[numberOfGCs];
        for (int i = 0; i < numberOfGCs; ++i) {
            GarbageCollectorMXBean gcBean = gcBeans.get(i);
            records[i] = new GCRecord(timestamp, hostname, vmName, gcBean.getName(), gcBean.getCollectionCount(), gcBean.getCollectionTime());
        }
        return records;
    }
}

