/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.oshi;

import kieker.monitoring.sampler.oshi.IOshiSamplerFactory;
import kieker.monitoring.sampler.oshi.samplers.CPUsCombinedPercSampler;
import kieker.monitoring.sampler.oshi.samplers.CPUsDetailedPercSampler;
import kieker.monitoring.sampler.oshi.samplers.DiskUsageSampler;
import kieker.monitoring.sampler.oshi.samplers.LoadAverageSampler;
import kieker.monitoring.sampler.oshi.samplers.MemSwapUsageSampler;
import kieker.monitoring.sampler.oshi.samplers.NetworkUtilizationSampler;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;

public enum OshiSamplerFactory implements IOshiSamplerFactory
{
    INSTANCE;

    private final HardwareAbstractionLayer hardwareAbstractionLayer = new SystemInfo().getHardware();

    public final HardwareAbstractionLayer getHardwareAbstractionLayer() {
        return this.hardwareAbstractionLayer;
    }

    @Override
    public CPUsCombinedPercSampler createSensorCPUsCombinedPerc() {
        return new CPUsCombinedPercSampler(this.hardwareAbstractionLayer);
    }

    @Override
    public CPUsDetailedPercSampler createSensorCPUsDetailedPerc() {
        return new CPUsDetailedPercSampler(this.hardwareAbstractionLayer);
    }

    @Override
    public MemSwapUsageSampler createSensorMemSwapUsage() {
        return new MemSwapUsageSampler(this.hardwareAbstractionLayer);
    }

    @Override
    public LoadAverageSampler createSensorLoadAverage() {
        return new LoadAverageSampler(this.hardwareAbstractionLayer);
    }

    @Override
    public NetworkUtilizationSampler createSensorNetworkUtilization() {
        return new NetworkUtilizationSampler(this.hardwareAbstractionLayer);
    }

    @Override
    public DiskUsageSampler createSensorDiskUsage() {
        return new DiskUsageSampler(this.hardwareAbstractionLayer);
    }
}

