/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.oshi.samplers;

import oshi.hardware.CentralProcessor;

public class CPUsDetailedPercConverter {
    private final int coreIndex;
    private long[] processorLoadTicksT0;
    private long[] processorLoadTicksT1;
    private long t0;
    private long t1;
    private double[] lastConversion;

    public CPUsDetailedPercConverter(int coreIndex) {
        this.coreIndex = coreIndex;
    }

    public void passNewProcessorLoadTicks(long[] processorLoadTicks) {
        if (processorLoadTicks == null || processorLoadTicks.length == 0) {
            return;
        }
        if (this.t0 == 0L || this.processorLoadTicksT0 == null) {
            this.t0 = System.currentTimeMillis();
            this.processorLoadTicksT0 = (long[])processorLoadTicks.clone();
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.t0 >= 1000L) {
                this.t0 = this.t1;
                this.t1 = currentTime;
                this.processorLoadTicksT0 = this.processorLoadTicksT1;
                this.processorLoadTicksT1 = (long[])processorLoadTicks.clone();
            }
        }
    }

    public void convertToPercentage() {
        if (this.processorLoadTicksT0 == null) {
            return;
        }
        if (this.processorLoadTicksT1 == null) {
            this.initialConvertToPercentage();
        } else {
            this.convertWithT1Ticks();
        }
    }

    private void initialConvertToPercentage() {
        this.lastConversion = new double[this.processorLoadTicksT0.length];
        long allTicks = 0L;
        for (long tick : this.processorLoadTicksT0) {
            allTicks += tick;
        }
        for (int i = 0; i < this.lastConversion.length; ++i) {
            if (allTicks == 0L) continue;
            this.lastConversion[i] = (double)this.processorLoadTicksT0[i] / (double)allTicks;
        }
    }

    private void convertWithT1Ticks() {
        int i;
        this.lastConversion = new double[this.processorLoadTicksT0.length];
        long[] deltas = new long[this.processorLoadTicksT0.length];
        long allTicks = 0L;
        for (i = 0; i < deltas.length; ++i) {
            long delta;
            deltas[i] = delta = this.processorLoadTicksT1[i] - this.processorLoadTicksT0[i];
            allTicks += delta;
        }
        for (i = 0; i < this.lastConversion.length; ++i) {
            if (allTicks == 0L) continue;
            this.lastConversion[i] = (double)deltas[i] / (double)allTicks;
        }
    }

    public double getSystemPerc() {
        if (this.lastConversion == null || this.lastConversion.length == 0 || this.lastConversion.length <= CentralProcessor.TickType.SYSTEM.getIndex()) {
            return 0.0;
        }
        return this.lastConversion[CentralProcessor.TickType.SYSTEM.getIndex()];
    }

    public double getNicePerc() {
        if (this.lastConversion == null || this.lastConversion.length == 0 || this.lastConversion.length <= CentralProcessor.TickType.NICE.getIndex()) {
            return 0.0;
        }
        return this.lastConversion[CentralProcessor.TickType.NICE.getIndex()];
    }

    public double getWaitPerc() {
        if (this.lastConversion == null || this.lastConversion.length == 0 || this.lastConversion.length <= CentralProcessor.TickType.IOWAIT.getIndex()) {
            return 0.0;
        }
        return this.lastConversion[CentralProcessor.TickType.IOWAIT.getIndex()];
    }

    public double getUserPerc() {
        if (this.lastConversion == null || this.lastConversion.length == 0 || this.lastConversion.length <= CentralProcessor.TickType.USER.getIndex()) {
            return 0.0;
        }
        return this.lastConversion[CentralProcessor.TickType.USER.getIndex()];
    }

    public double getIrqPerc() {
        if (this.lastConversion == null || this.lastConversion.length == 0 || this.lastConversion.length <= CentralProcessor.TickType.IRQ.getIndex() || this.lastConversion.length <= CentralProcessor.TickType.SOFTIRQ.getIndex()) {
            return 0.0;
        }
        return this.lastConversion[CentralProcessor.TickType.IRQ.getIndex()] + this.lastConversion[CentralProcessor.TickType.SOFTIRQ.getIndex()];
    }

    public double getIdlePerc() {
        if (this.lastConversion == null || this.lastConversion.length == 0 || this.lastConversion.length <= CentralProcessor.TickType.IDLE.getIndex()) {
            return 0.0;
        }
        return this.lastConversion[CentralProcessor.TickType.IDLE.getIndex()];
    }

    public double getCombinedPerc() {
        if (this.lastConversion == null || this.lastConversion.length == 0) {
            return 0.0;
        }
        double combinedUsage = 0.0;
        for (int i = 0; i < this.lastConversion.length; ++i) {
            if (i == CentralProcessor.TickType.IDLE.getIndex()) continue;
            combinedUsage += this.lastConversion[i];
        }
        return combinedUsage;
    }

    public int getCoreIndex() {
        return this.coreIndex;
    }
}

