/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kieker.common.configuration.Configuration;

final class KiekerLogFolder {
    private KiekerLogFolder() {
    }

    public static Path buildKiekerLogFolder(String customStoragePath, Configuration configuration) {
        SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd'-'HHmmss", Locale.US);
        date.setTimeZone(TimeZone.getTimeZone("UTC"));
        String currentDateStr = date.format(new Date()) + "-" + System.nanoTime();
        String hostName = configuration.getStringProperty("kieker.monitoring.hostname");
        String controllerName = configuration.getStringProperty("kieker.monitoring.name");
        String filename = String.format("%s-%s-UTC-%s-%s", "kieker", currentDateStr, hostName, controllerName);
        return Paths.get(customStoragePath, filename);
    }
}

