/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.repository;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.repository.AbstractRepository;
import kieker.analysis.repository.annotation.Repository;
import kieker.common.configuration.Configuration;
import kieker.tools.trace.analysis.filter.visualization.graph.Color;

@Repository(name="Trace color repository", description="Provides color information for trace coloring", configuration={@Property(name="traceColorFileName", defaultValue="")})
public class TraceColorRepository
extends AbstractRepository {
    public static final String CONFIG_PROPERTY_NAME_TRACE_COLOR_FILE_NAME = "traceColorFileName";
    private static final String DEFAULT_KEYWORD = "default";
    private static final String COLLISION_KEYWORD = "collision";
    private static final String COLOR_REGEX = "0x([0-9|a-f]{6})";
    private static final Pattern COLOR_PATTERN = Pattern.compile("0x([0-9|a-f]{6})");
    private static final String DELIMITER_REGEX = "=";
    private static final String ENCODING = "UTF-8";
    private final ConcurrentMap<Long, Color> colorMap;
    private final Color defaultColor;
    private final Color collisionColor;

    public TraceColorRepository(Configuration configuration, IProjectContext projectContext) throws IOException {
        this(configuration, TraceColorRepository.readDataFromFile(configuration.getStringProperty(CONFIG_PROPERTY_NAME_TRACE_COLOR_FILE_NAME)), projectContext);
    }

    public TraceColorRepository(Configuration configuration, TraceColorRepositoryData colorData, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.colorMap = colorData.getColorMap();
        this.defaultColor = colorData.getDefaultColor();
        this.collisionColor = colorData.getCollisionColor();
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return this.configuration;
    }

    public Map<Long, Color> getColorMap() {
        return Collections.unmodifiableMap(this.colorMap);
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public Color getCollisionColor() {
        return this.collisionColor;
    }

    private static Long parseTraceId(String input) {
        try {
            return Long.parseLong(input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Color parseColor(String input) {
        Matcher matcher = COLOR_PATTERN.matcher(input);
        if (!matcher.matches()) {
            return null;
        }
        int rgbValue = Integer.parseInt(matcher.group(1), 16);
        return new Color(rgbValue);
    }

    public static TraceColorRepository createFromFile(String fileName, IProjectContext projectContext) throws IOException {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_TRACE_COLOR_FILE_NAME, fileName);
        return new TraceColorRepository(configuration, TraceColorRepository.readDataFromFile(fileName), projectContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TraceColorRepositoryData readDataFromFile(String fileName) throws IOException {
        try (BufferedReader reader = null;){
            String currentLine;
            reader = Files.newBufferedReader(Paths.get(fileName, new String[0]), Charset.forName(ENCODING));
            ConcurrentHashMap<Long, Color> colorMap = new ConcurrentHashMap<Long, Color>();
            Color defaultColor = Color.BLACK;
            Color collisionColor = Color.GRAY;
            while ((currentLine = reader.readLine()) != null) {
                String[] parts = currentLine.split(DELIMITER_REGEX);
                if (parts.length != 2) continue;
                String traceName = parts[0];
                String colorSpecification = parts[1];
                Color traceColor = TraceColorRepository.parseColor(colorSpecification);
                if (DEFAULT_KEYWORD.equals(traceName)) {
                    if (traceColor == null) continue;
                    defaultColor = traceColor;
                    continue;
                }
                if (COLLISION_KEYWORD.equals(traceName)) {
                    if (traceColor == null) continue;
                    collisionColor = traceColor;
                    continue;
                }
                Long traceId = TraceColorRepository.parseTraceId(traceName);
                if (traceId == null || traceColor == null) continue;
                colorMap.put(traceId, traceColor);
            }
            TraceColorRepositoryData traceColorRepositoryData = new TraceColorRepositoryData(colorMap, defaultColor, collisionColor);
            return traceColorRepositoryData;
        }
    }

    public static class TraceColorRepositoryData {
        private final ConcurrentMap<Long, Color> colorMap;
        private final Color defaultColor;
        private final Color collisionColor;

        public TraceColorRepositoryData(ConcurrentMap<Long, Color> colorMap, Color defaultColor, Color collisionColor) {
            this.colorMap = colorMap;
            this.defaultColor = defaultColor;
            this.collisionColor = collisionColor;
        }

        ConcurrentMap<Long, Color> getColorMap() {
            return this.colorMap;
        }

        Color getDefaultColor() {
            return this.defaultColor;
        }

        Color getCollisionColor() {
            return this.collisionColor;
        }
    }
}

