/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.dependency.graph;

import java.util.concurrent.TimeUnit;
import kieker.model.system.model.AbstractMessage;
import kieker.visualization.trace.dependency.graph.AbstractNodeDecorator;
import kieker.visualization.trace.dependency.graph.DependencyGraphNode;
import kieker.visualization.trace.dependency.graph.ResponseTimeDecoration;

public class ResponseTimeNodeDecorator
extends AbstractNodeDecorator {
    private final TimeUnit displayTimeunit;

    public ResponseTimeNodeDecorator(TimeUnit displayTimeunit) {
        this.displayTimeunit = displayTimeunit;
    }

    @Override
    public void processMessage(AbstractMessage message, DependencyGraphNode<?> sourceNode, DependencyGraphNode<?> targetNode, TimeUnit timeunit) {
        if (sourceNode.equals(targetNode)) {
            return;
        }
        ResponseTimeDecoration timeDecoration = targetNode.getDecoration(ResponseTimeDecoration.class);
        if (timeDecoration == null) {
            timeDecoration = new ResponseTimeDecoration(timeunit, this.displayTimeunit);
            targetNode.addDecoration(timeDecoration);
        }
        timeDecoration.registerExecution(message.getReceivingExecution());
    }
}

