/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.debug.hotspotdetection;

import java.io.File;
import java.time.temporal.ChronoUnit;
import kieker.analysis.debug.hotspotdetection.HotspotDetectionStage;
import kieker.analysis.signature.JavaComponentSignatureExtractor;
import kieker.analysis.signature.JavaOperationSignatureExtractor;
import kieker.analysis.source.file.DirectoryReaderStage;
import kieker.analysis.source.file.DirectoryScannerStage;
import kieker.analysis.stage.flow.FlowTraceEventMatcher;
import kieker.analysis.stage.general.ControlledEventReleaseStage;
import kieker.analysis.stage.model.AssemblyModelAssemblerStage;
import kieker.analysis.stage.model.DeploymentModelAssemblerStage;
import kieker.analysis.stage.model.OperationAndCallGeneratorStage;
import kieker.analysis.stage.model.TypeModelAssemblerStage;
import kieker.analysis.stage.model.data.OperationEvent;
import kieker.analysis.trace.reconstruction.FlowRecordTraceReconstructionStage;
import kieker.common.record.flow.IFlowRecord;
import kieker.model.analysismodel.assembly.AssemblyFactory;
import kieker.model.analysismodel.assembly.AssemblyModel;
import kieker.model.analysismodel.deployment.DeploymentFactory;
import kieker.model.analysismodel.deployment.DeploymentModel;
import kieker.model.analysismodel.sources.SourceModel;
import kieker.model.analysismodel.sources.SourcesFactory;
import kieker.model.analysismodel.type.TypeFactory;
import kieker.model.analysismodel.type.TypeModel;
import teetime.framework.Configuration;
import teetime.stage.InstanceOfFilter;
import teetime.stage.basic.distributor.Distributor;

public class HotspotDetectionConfiguration
extends Configuration {
    private static final String DYNAMIC_SOURCE = null;

    public HotspotDetectionConfiguration(File importDirectory) {
        TypeModel typeModel = TypeFactory.eINSTANCE.createTypeModel();
        AssemblyModel assemblyModel = AssemblyFactory.eINSTANCE.createAssemblyModel();
        DeploymentModel deploymentModel = DeploymentFactory.eINSTANCE.createDeploymentModel();
        SourceModel sourceModel = SourcesFactory.eINSTANCE.createSourceModel();
        DirectoryScannerStage directoryScannerStage = new DirectoryScannerStage(importDirectory);
        DirectoryReaderStage directoryReaderStage = new DirectoryReaderStage(false, 80860);
        InstanceOfFilter instanceOfFilter = new InstanceOfFilter(IFlowRecord.class);
        Distributor flowRecordDistributor = new Distributor();
        OperationAndCallGeneratorStage operationAndCallGeneratorStage = new OperationAndCallGeneratorStage(true);
        TypeModelAssemblerStage typeModelAssembler = new TypeModelAssemblerStage(typeModel, sourceModel, DYNAMIC_SOURCE, new JavaComponentSignatureExtractor(), new JavaOperationSignatureExtractor());
        AssemblyModelAssemblerStage assemblyModelAssembler = new AssemblyModelAssemblerStage(typeModel, assemblyModel, sourceModel, DYNAMIC_SOURCE);
        DeploymentModelAssemblerStage deploymentModelAssemblerStage = new DeploymentModelAssemblerStage(assemblyModel, deploymentModel, sourceModel, DYNAMIC_SOURCE);
        ControlledEventReleaseStage<OperationEvent, IFlowRecord> flowRecordMerger = new ControlledEventReleaseStage<OperationEvent, IFlowRecord>(new FlowTraceEventMatcher());
        FlowRecordTraceReconstructionStage traceReconstructor = new FlowRecordTraceReconstructionStage(deploymentModel, ChronoUnit.NANOS);
        HotspotDetectionStage hotspotDetector = new HotspotDetectionStage();
        super.connectPorts(directoryScannerStage.getOutputPort(), directoryReaderStage.getInputPort());
        super.connectPorts(directoryReaderStage.getOutputPort(), instanceOfFilter.getInputPort());
        super.connectPorts(instanceOfFilter.getMatchedOutputPort(), flowRecordDistributor.getInputPort());
        super.connectPorts(flowRecordDistributor.getNewOutputPort(), operationAndCallGeneratorStage.getInputPort());
        super.connectPorts(operationAndCallGeneratorStage.getOperationOutputPort(), typeModelAssembler.getInputPort());
        super.connectPorts(typeModelAssembler.getOutputPort(), assemblyModelAssembler.getInputPort());
        super.connectPorts(assemblyModelAssembler.getOutputPort(), deploymentModelAssemblerStage.getInputPort());
        super.connectPorts(deploymentModelAssemblerStage.getOutputPort(), flowRecordMerger.getControlInputPort());
        super.connectPorts(flowRecordDistributor.getNewOutputPort(), flowRecordMerger.getBaseInputPort());
        super.connectPorts(flowRecordMerger.getOutputPort(), traceReconstructor.getInputPort());
        super.connectPorts(traceReconstructor.getOutputPort(), hotspotDetector.getInputPort());
    }
}

