/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.graph.dependency;

import java.time.temporal.ChronoUnit;
import kieker.analysis.graph.IVertex;
import kieker.analysis.util.time.ChronoUnitToSymbolMapper;
import kieker.model.analysismodel.statistics.EPredefinedUnits;
import kieker.model.analysismodel.statistics.EPropertyType;
import kieker.model.analysismodel.statistics.StatisticRecord;
import kieker.model.analysismodel.statistics.Statistics;
import kieker.model.analysismodel.statistics.StatisticsModel;

public class ResponseTimeDecorator {
    private final StatisticsModel statisticsModel;
    private final String timeUnit;

    public ResponseTimeDecorator(StatisticsModel statisticsModel, ChronoUnit chronoUnit) {
        this.statisticsModel = statisticsModel;
        this.timeUnit = ChronoUnitToSymbolMapper.create().apply(chronoUnit);
    }

    public void decorate(IVertex vertex, Object object) {
        vertex.setPropertyIfAbsent("min response time", this.getStatisticValue(object, EPropertyType.MIN));
        vertex.setPropertyIfAbsent("max response time", this.getStatisticValue(object, EPropertyType.MAX));
        vertex.setPropertyIfAbsent("total response time", this.getStatisticValue(object, EPropertyType.TOTAL));
        vertex.setPropertyIfAbsent("mean response time", this.getStatisticValue(object, EPropertyType.MEAN));
        vertex.setPropertyIfAbsent("median response time", this.getStatisticValue(object, EPropertyType.MEDIAN));
        vertex.setPropertyIfAbsent("time unit", this.timeUnit);
    }

    private long getStatisticValue(Object object, EPropertyType property) {
        Long value;
        if (this.statisticsModel.getStatistics().containsKey(object) && (value = (Long)((StatisticRecord)((Statistics)this.statisticsModel.getStatistics().get(object)).getStatistics().get((Object)EPredefinedUnits.RESPONSE_TIME)).getProperties().get((Object)property)) != null) {
            return value;
        }
        return 0L;
    }
}

