/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.flow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.analysis.plugin.filter.flow.TraceEventRecords;
import kieker.common.configuration.Configuration;
import kieker.common.record.flow.IFlowRecord;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.flow.trace.ConstructionEvent;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.flow.trace.operation.CallOperationEvent;
import kieker.common.record.flow.trace.operation.constructor.AfterConstructorEvent;
import kieker.common.record.flow.trace.operation.constructor.AfterConstructorFailedEvent;
import kieker.common.record.flow.trace.operation.constructor.BeforeConstructorEvent;
import kieker.common.record.flow.trace.operation.constructor.object.AfterConstructorFailedObjectEvent;
import kieker.common.record.flow.trace.operation.constructor.object.AfterConstructorObjectEvent;
import kieker.common.record.flow.trace.operation.constructor.object.BeforeConstructorObjectEvent;
import kieker.common.record.flow.trace.operation.object.AfterOperationFailedObjectEvent;
import kieker.common.record.flow.trace.operation.object.AfterOperationObjectEvent;
import kieker.common.record.flow.trace.operation.object.BeforeOperationObjectEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Plugin(name="Trace Reconstruction Filter (Event)", description="Filter to reconstruct event based (flow) traces", outputPorts={@OutputPort(name="validTraces", description="Outputs valid traces", eventTypes={TraceEventRecords.class}), @OutputPort(name="invalidTraces", description="Outputs traces missing crucial records", eventTypes={TraceEventRecords.class})}, configuration={@Property(name="timeunit", defaultValue="NANOSECONDS"), @Property(name="maxTraceDuration", defaultValue="9223372036854775807"), @Property(name="maxTraceTimeout", defaultValue="9223372036854775807"), @Property(name="repairEventBasedTraces", defaultValue="false")})
public final class EventRecordTraceReconstructionFilter
extends AbstractFilterPlugin {
    public static final String OUTPUT_PORT_NAME_TRACE_VALID = "validTraces";
    public static final String OUTPUT_PORT_NAME_TRACE_INVALID = "invalidTraces";
    public static final String INPUT_PORT_NAME_TRACE_RECORDS = "traceRecords";
    public static final String INPUT_PORT_NAME_TRACEEVENT_RECORDS = "traceEventRecords";
    public static final String INPUT_PORT_NAME_TIME_EVENT = "timestamps";
    public static final String CONFIG_PROPERTY_NAME_TIMEUNIT = "timeunit";
    public static final String CONFIG_PROPERTY_NAME_MAX_TRACE_DURATION = "maxTraceDuration";
    public static final String CONFIG_PROPERTY_NAME_MAX_TRACE_TIMEOUT = "maxTraceTimeout";
    public static final String CONFIG_PROPERTY_VALUE_MAX_TIME = "9223372036854775807";
    public static final String CONFIG_PROPERTY_VALUE_TIMEUNIT = "NANOSECONDS";
    public static final String CONFIG_PROPERTY_NAME_REPAIR_EVENT_BASED_TRACES = "repairEventBasedTraces";
    private final TimeUnit timeunit = this.recordsTimeUnitFromProjectContext;
    private final long maxTraceDuration;
    private final long maxTraceTimeout;
    private final boolean hasTimeout;
    private final boolean repairEventBasedTracesEnabled;
    private long maxEncounteredLoggingTimestamp = -1L;
    private final Map<Long, TraceBuffer> traceId2trace;

    public EventRecordTraceReconstructionFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        TimeUnit configTimeunit;
        String configTimeunitProperty = configuration.getStringProperty(CONFIG_PROPERTY_NAME_TIMEUNIT);
        try {
            configTimeunit = TimeUnit.valueOf(configTimeunitProperty);
        }
        catch (IllegalArgumentException ex) {
            this.logger.warn("{} is no valid TimeUnit! Using inherited value of {} instead.", (Object)configTimeunitProperty, (Object)this.timeunit.name());
            configTimeunit = this.timeunit;
        }
        this.repairEventBasedTracesEnabled = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_REPAIR_EVENT_BASED_TRACES);
        this.maxTraceDuration = this.timeunit.convert(configuration.getLongProperty(CONFIG_PROPERTY_NAME_MAX_TRACE_DURATION), configTimeunit);
        this.maxTraceTimeout = this.timeunit.convert(configuration.getLongProperty(CONFIG_PROPERTY_NAME_MAX_TRACE_TIMEOUT), configTimeunit);
        this.hasTimeout = this.maxTraceTimeout != Long.MAX_VALUE || this.maxTraceDuration != Long.MAX_VALUE;
        this.traceId2trace = new ConcurrentHashMap<Long, TraceBuffer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InputPort(name="timestamps", description="Input port for a periodic time signal", eventTypes={Long.class})
    public void newEvent(Long timestamp) {
        EventRecordTraceReconstructionFilter eventRecordTraceReconstructionFilter = this;
        synchronized (eventRecordTraceReconstructionFilter) {
            if (this.hasTimeout) {
                this.processTimeoutQueue(timestamp);
            }
        }
    }

    @InputPort(name="traceEventRecords", description="Reconstruct traces from incoming traces", eventTypes={TraceEventRecords.class})
    public void newTraceEventRecord(TraceEventRecords traceEventRecords) {
        TraceMetadata trace = traceEventRecords.getTraceMetadata();
        if (null != trace) {
            this.newEvent(trace);
        }
        for (AbstractTraceEvent record : traceEventRecords.getTraceEvents()) {
            this.newEvent(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InputPort(name="traceRecords", description="Reconstruct traces from incoming flow records", eventTypes={TraceMetadata.class, AbstractTraceEvent.class})
    public void newEvent(IFlowRecord record) {
        long loggingTimestamp;
        EventRecordTraceReconstructionFilter eventRecordTraceReconstructionFilter;
        TraceBuffer traceBuffer;
        Long traceId;
        if (record instanceof TraceMetadata) {
            traceId = ((TraceMetadata)record).getTraceId();
            traceBuffer = this.traceId2trace.get(traceId);
            if (traceBuffer == null) {
                eventRecordTraceReconstructionFilter = this;
                synchronized (eventRecordTraceReconstructionFilter) {
                    traceBuffer = this.traceId2trace.get(traceId);
                    if (traceBuffer == null) {
                        traceBuffer = new TraceBuffer();
                        traceBuffer.setRepairEventBasedTracesEnabled(this.repairEventBasedTracesEnabled);
                        this.traceId2trace.put(traceId, traceBuffer);
                    }
                }
            }
            traceBuffer.setTrace((TraceMetadata)record);
            loggingTimestamp = -1L;
        } else if (record instanceof AbstractTraceEvent) {
            traceId = ((AbstractTraceEvent)record).getTraceId();
            traceBuffer = this.traceId2trace.get(traceId);
            if (traceBuffer == null) {
                eventRecordTraceReconstructionFilter = this;
                synchronized (eventRecordTraceReconstructionFilter) {
                    traceBuffer = this.traceId2trace.get(traceId);
                    if (traceBuffer == null) {
                        traceBuffer = new TraceBuffer();
                        traceBuffer.setRepairEventBasedTracesEnabled(this.repairEventBasedTracesEnabled);
                        this.traceId2trace.put(traceId, traceBuffer);
                    }
                }
            }
            traceBuffer.insertEvent((AbstractTraceEvent)record);
            loggingTimestamp = ((AbstractTraceEvent)record).getTimestamp();
        } else {
            return;
        }
        if (traceBuffer.isFinished()) {
            eventRecordTraceReconstructionFilter = this;
            synchronized (eventRecordTraceReconstructionFilter) {
                this.traceId2trace.remove(traceId);
            }
            super.deliver(OUTPUT_PORT_NAME_TRACE_VALID, traceBuffer.toTraceEvents());
        }
        if (this.hasTimeout) {
            eventRecordTraceReconstructionFilter = this;
            synchronized (eventRecordTraceReconstructionFilter) {
                if (loggingTimestamp > this.maxEncounteredLoggingTimestamp) {
                    this.maxEncounteredLoggingTimestamp = loggingTimestamp;
                }
                this.processTimeoutQueue(this.maxEncounteredLoggingTimestamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate(boolean error) {
        EventRecordTraceReconstructionFilter eventRecordTraceReconstructionFilter = this;
        synchronized (eventRecordTraceReconstructionFilter) {
            Collection<Long> sortedTraceIds = this.getSortedTraceIds(this.traceId2trace.keySet());
            for (Long traceId : sortedTraceIds) {
                TraceBuffer traceBuffer = this.traceId2trace.get(traceId);
                if (this.repairEventBasedTracesEnabled && !traceBuffer.getEventStack().isEmpty()) {
                    traceBuffer.repairAllBeforeEventsLeftInStackAtTermination();
                }
                if (traceBuffer.isInvalid()) {
                    super.deliver(OUTPUT_PORT_NAME_TRACE_INVALID, traceBuffer.toTraceEvents());
                    continue;
                }
                super.deliver(OUTPUT_PORT_NAME_TRACE_VALID, traceBuffer.toTraceEvents());
            }
            this.traceId2trace.clear();
        }
    }

    private void processTimeoutQueue(long timestamp) {
        long duration = timestamp - this.maxTraceDuration;
        long traceTimeout = timestamp - this.maxTraceTimeout;
        Collection<Long> sortedTraceIds = this.getSortedTraceIds(this.traceId2trace.keySet());
        for (Long traceId : sortedTraceIds) {
            TraceBuffer traceBuffer = this.traceId2trace.get(traceId);
            if (traceBuffer.getMaxLoggingTimestamp() > traceTimeout && traceBuffer.getMinLoggingTimestamp() > duration) continue;
            if (traceBuffer.isInvalid()) {
                super.deliver(OUTPUT_PORT_NAME_TRACE_INVALID, traceBuffer.toTraceEvents());
            } else {
                super.deliver(OUTPUT_PORT_NAME_TRACE_VALID, traceBuffer.toTraceEvents());
            }
            this.traceId2trace.remove(traceId);
        }
    }

    private Collection<Long> getSortedTraceIds(Set<Long> keys) {
        ArrayList<Long> copiedKeys = new ArrayList<Long>(keys);
        Collections.sort(copiedKeys);
        return copiedKeys;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_TIMEUNIT, this.timeunit.name());
        configuration.setProperty(CONFIG_PROPERTY_NAME_MAX_TRACE_DURATION, String.valueOf(this.maxTraceDuration));
        configuration.setProperty(CONFIG_PROPERTY_NAME_MAX_TRACE_TIMEOUT, String.valueOf(this.maxTraceTimeout));
        configuration.setProperty(CONFIG_PROPERTY_NAME_REPAIR_EVENT_BASED_TRACES, Boolean.toString(this.repairEventBasedTracesEnabled));
        return configuration;
    }

    private static final class TraceBuffer {
        private static final Logger LOGGER = LoggerFactory.getLogger(TraceBuffer.class);
        private static final Comparator<AbstractTraceEvent> COMPARATOR = new TraceEventComperator();
        private TraceMetadata trace;
        private final SortedSet<AbstractTraceEvent> events = new TreeSet<AbstractTraceEvent>(COMPARATOR);
        private boolean closeable;
        private boolean damaged;
        private int openEvents;
        private int maxOrderIndex = -1;
        private long minLoggingTimestamp = Long.MAX_VALUE;
        private long maxLoggingTimestamp = -1L;
        private long traceId = -1L;
        private boolean beforeEventStackEmptyAtTermination;
        private boolean repairEventBasedTracesEnabled;
        private final Deque<BeforeOperationEvent> beforeEventStack = new LinkedList<BeforeOperationEvent>();
        private final Deque<AbstractTraceEvent> eventQueue = new LinkedList<AbstractTraceEvent>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertEvent(AbstractTraceEvent event) {
            long myTraceId = event.getTraceId();
            if (this.repairEventBasedTracesEnabled) {
                if (event instanceof CallOperationEvent || event instanceof ConstructionEvent || this.beforeEventStackEmptyAtTermination) {
                    this.eventQueue.add(event);
                } else {
                    this.checkIfAfterEventsMissingThenRepair(event);
                }
            } else {
                this.eventQueue.add(event);
            }
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                while (!this.eventQueue.isEmpty()) {
                    int orderIndex;
                    AbstractTraceEvent receivedEvent = this.eventQueue.removeFirst();
                    if (this.traceId == -1L) {
                        this.traceId = myTraceId;
                    } else if (this.traceId != myTraceId) {
                        LOGGER.error("Invalid traceId! Expected: {} but found: {} in event {}", new Object[]{this.traceId, myTraceId, event.toString()});
                        this.damaged = true;
                    }
                    long loggingTimestamp = receivedEvent.getTimestamp();
                    if (loggingTimestamp > this.maxLoggingTimestamp) {
                        this.maxLoggingTimestamp = loggingTimestamp;
                    }
                    if (loggingTimestamp < this.minLoggingTimestamp) {
                        this.minLoggingTimestamp = loggingTimestamp;
                    }
                    if ((orderIndex = receivedEvent.getOrderIndex()) > this.maxOrderIndex) {
                        this.maxOrderIndex = orderIndex;
                    }
                    if (receivedEvent instanceof BeforeOperationEvent) {
                        if (orderIndex == 0) {
                            this.closeable = true;
                        }
                        ++this.openEvents;
                    } else if (receivedEvent instanceof AfterOperationEvent) {
                        --this.openEvents;
                    } else if (receivedEvent instanceof AfterOperationFailedEvent) {
                        --this.openEvents;
                    }
                    if (this.events.add(receivedEvent)) continue;
                    LOGGER.error("Duplicate entry for orderIndex {} with traceId {}", (Object)orderIndex, (Object)myTraceId);
                    this.damaged = true;
                }
            }
        }

        public void checkIfAfterEventsMissingThenRepair(AbstractTraceEvent event) {
            boolean alreadyRepairedSomeEvents;
            int orderIndex = event.getOrderIndex();
            boolean bl = alreadyRepairedSomeEvents = orderIndex <= this.maxOrderIndex;
            if (alreadyRepairedSomeEvents) {
                orderIndex = this.maxOrderIndex + 1;
            }
            if (event instanceof BeforeOperationEvent) {
                this.beforeEventStack.addLast((BeforeOperationEvent)event);
                this.eventQueue.add(event);
            } else if (event instanceof AfterOperationEvent) {
                while (!this.beforeEventStack.getLast().getOperationSignature().equals(((AfterOperationEvent)event).getOperationSignature()) && !this.beforeEventStack.getLast().getClassSignature().equals(((AfterOperationEvent)event).getClassSignature())) {
                    BeforeOperationEvent beforeEvent = this.beforeEventStack.getLast();
                    String opSignature = beforeEvent.getOperationSignature();
                    String classSignature = beforeEvent.getClassSignature();
                    long timestamp = event.getTimestamp();
                    long traceID = event.getTraceId();
                    if (beforeEvent instanceof BeforeConstructorObjectEvent) {
                        this.eventQueue.add(new AfterConstructorObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((BeforeConstructorObjectEvent)this.beforeEventStack.getLast()).getObjectId()));
                    } else if (beforeEvent instanceof BeforeConstructorEvent) {
                        this.eventQueue.add(new AfterConstructorEvent(timestamp, traceID, orderIndex, opSignature, classSignature));
                    } else if (beforeEvent instanceof BeforeOperationObjectEvent) {
                        this.eventQueue.add(new AfterOperationObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((BeforeOperationObjectEvent)this.beforeEventStack.getLast()).getObjectId()));
                    } else {
                        this.eventQueue.add(new AfterOperationEvent(timestamp, traceID, orderIndex, opSignature, classSignature));
                    }
                    this.beforeEventStack.removeLast();
                    ++orderIndex;
                }
                this.beforeEventStack.removeLast();
                if (!alreadyRepairedSomeEvents && orderIndex - 1 == this.maxOrderIndex) {
                    this.eventQueue.add(event);
                } else {
                    String opSignature = ((AfterOperationEvent)event).getOperationSignature();
                    String classSignature = ((AfterOperationEvent)event).getClassSignature();
                    long timestamp = event.getTimestamp();
                    long traceID = event.getTraceId();
                    if (event instanceof AfterConstructorFailedObjectEvent) {
                        this.eventQueue.add(new AfterConstructorFailedObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((AfterConstructorFailedObjectEvent)event).getCause(), ((AfterConstructorFailedObjectEvent)event).getObjectId()));
                    } else if (event instanceof AfterConstructorObjectEvent) {
                        this.eventQueue.add(new AfterConstructorObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((AfterConstructorObjectEvent)event).getObjectId()));
                    } else if (event instanceof AfterConstructorFailedEvent) {
                        this.eventQueue.add(new AfterConstructorFailedEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((AfterConstructorFailedEvent)event).getCause()));
                    } else if (event instanceof AfterConstructorEvent) {
                        this.eventQueue.add(new AfterConstructorEvent(timestamp, traceID, orderIndex, opSignature, classSignature));
                    } else if (event instanceof AfterOperationFailedObjectEvent) {
                        this.eventQueue.add(new AfterOperationFailedObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((AfterOperationFailedObjectEvent)event).getCause(), ((AfterOperationFailedObjectEvent)event).getObjectId()));
                    } else if (event instanceof AfterOperationObjectEvent) {
                        this.eventQueue.add(new AfterOperationObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((AfterOperationObjectEvent)event).getObjectId()));
                    } else if (event instanceof AfterOperationFailedEvent) {
                        this.eventQueue.add(new AfterOperationFailedEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((AfterOperationFailedEvent)event).getCause()));
                    } else {
                        this.eventQueue.add(new AfterOperationEvent(timestamp, traceID, orderIndex, opSignature, classSignature));
                    }
                }
            }
        }

        public void repairAllBeforeEventsLeftInStackAtTermination() {
            this.beforeEventStackEmptyAtTermination = true;
            while (!this.beforeEventStack.isEmpty()) {
                BeforeOperationEvent beforeEvent = this.beforeEventStack.getLast();
                String opSignature = beforeEvent.getOperationSignature();
                String classSignature = beforeEvent.getClassSignature();
                long timestamp = beforeEvent.getTimestamp();
                long traceID = beforeEvent.getTraceId();
                int orderIndex = this.maxOrderIndex + 1;
                if (beforeEvent instanceof BeforeConstructorObjectEvent) {
                    this.insertEvent(new AfterConstructorObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((BeforeConstructorObjectEvent)this.beforeEventStack.getLast()).getObjectId()));
                } else if (beforeEvent instanceof BeforeConstructorEvent) {
                    this.insertEvent(new AfterConstructorEvent(timestamp, traceID, orderIndex, opSignature, classSignature));
                } else if (beforeEvent instanceof BeforeOperationObjectEvent) {
                    this.insertEvent(new AfterOperationObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((BeforeOperationObjectEvent)this.beforeEventStack.getLast()).getObjectId()));
                } else {
                    this.insertEvent(new AfterOperationEvent(timestamp, traceID, orderIndex, opSignature, classSignature));
                }
                this.beforeEventStack.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTrace(TraceMetadata trace) {
            long myTraceId = trace.getTraceId();
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                if (this.traceId == -1L) {
                    this.traceId = myTraceId;
                } else if (this.traceId != myTraceId) {
                    LOGGER.error("Invalid traceId! Expected: {} but found: {} in trace {}", new Object[]{this.traceId, myTraceId, trace.toString()});
                    this.damaged = true;
                }
                if (this.trace == null) {
                    this.trace = trace;
                } else {
                    LOGGER.error("Duplicate Trace entry for traceId {}", (Object)myTraceId);
                    this.damaged = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFinished() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return this.closeable && !this.isInvalid();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInvalid() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return this.trace == null || this.damaged || this.openEvents != 0 || this.maxOrderIndex + 1 != this.events.size() || this.events.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TraceEventRecords toTraceEvents() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return new TraceEventRecords(this.trace, this.events.toArray(new AbstractTraceEvent[this.events.size()]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getMaxLoggingTimestamp() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return this.maxLoggingTimestamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getMinLoggingTimestamp() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return this.minLoggingTimestamp;
            }
        }

        public void setRepairEventBasedTracesEnabled(boolean isEnabled) {
            this.repairEventBasedTracesEnabled = isEnabled;
        }

        public Deque<BeforeOperationEvent> getEventStack() {
            return this.beforeEventStack;
        }

        private static final class TraceEventComperator
        implements Comparator<AbstractTraceEvent>,
        Serializable {
            private static final long serialVersionUID = 8920737343446332517L;

            @Override
            public int compare(AbstractTraceEvent o1, AbstractTraceEvent o2) {
                return o1.getOrderIndex() - o2.getOrderIndex();
            }
        }
    }
}

