/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.flow;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.analysis.plugin.filter.flow.TraceEventRecords;
import kieker.common.configuration.Configuration;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.flow.trace.operation.AbstractOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;

@Deprecated
@Plugin(description="This filter tries to aggregate similar Traces into a single trace.", outputPorts={@OutputPort(name="tracesOut", description="Output port for the processed traces", eventTypes={TraceEventRecords.class})}, configuration={@Property(name="timeunit", defaultValue="NANOSECONDS"), @Property(name="maxCollectionDuration", defaultValue="5000000000")})
public class TraceAggregationFilter
extends AbstractFilterPlugin {
    public static final String OUTPUT_PORT_NAME_TRACES = "tracesOut";
    public static final String INPUT_PORT_NAME_TRACES = "tracesIn";
    public static final String CONFIG_PROPERTY_NAME_TIMEUNIT = "timeunit";
    public static final String INPUT_PORT_NAME_TIME_EVENT = "timestamp";
    public static final String CONFIG_PROPERTY_VALUE_TIMEUNIT = "NANOSECONDS";
    public static final String CONFIG_PROPERTY_NAME_MAX_COLLECTION_DURATION = "maxCollectionDuration";
    public static final String CONFIG_PROPERTY_VALUE_MAX_COLLECTION_DURATION = "5000000000";
    private final TimeUnit timeunit;
    private final long maxCollectionDuration;
    private final Map<TraceEventRecords, TraceAggregationBuffer> trace2buffer;

    public TraceAggregationFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        TimeUnit configTimeunit;
        this.timeunit = this.recordsTimeUnitFromProjectContext;
        String configTimeunitProperty = configuration.getStringProperty(CONFIG_PROPERTY_NAME_TIMEUNIT);
        try {
            configTimeunit = TimeUnit.valueOf(configTimeunitProperty);
        }
        catch (IllegalArgumentException ex) {
            this.logger.warn("{} is no valid TimeUnit! Using inherited value of {} instead.", (Object)configTimeunitProperty, (Object)this.timeunit.name());
            configTimeunit = this.timeunit;
        }
        this.maxCollectionDuration = this.timeunit.convert(configuration.getLongProperty(CONFIG_PROPERTY_NAME_MAX_COLLECTION_DURATION), configTimeunit);
        this.trace2buffer = new TreeMap<TraceEventRecords, TraceAggregationBuffer>(new TraceComperator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InputPort(name="timestamp", description="Time signal for timeouts", eventTypes={Long.class})
    public void newEvent(Long timestamp) {
        TraceAggregationFilter traceAggregationFilter = this;
        synchronized (traceAggregationFilter) {
            this.processTimeoutQueue(timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InputPort(name="tracesIn", description="Collect identical traces and aggregate them.", eventTypes={TraceEventRecords.class})
    public void newEvent(TraceEventRecords traceEventRecords) {
        long timestamp = this.timeunit.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        TraceAggregationFilter traceAggregationFilter = this;
        synchronized (traceAggregationFilter) {
            TraceAggregationBuffer traceBuffer = this.trace2buffer.get(traceEventRecords);
            if (traceBuffer == null) {
                traceBuffer = new TraceAggregationBuffer(timestamp, traceEventRecords);
                this.trace2buffer.put(traceEventRecords, traceBuffer);
            }
            traceBuffer.count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate(boolean error) {
        TraceAggregationFilter traceAggregationFilter = this;
        synchronized (traceAggregationFilter) {
            for (Map.Entry<TraceEventRecords, TraceAggregationBuffer> entry : this.trace2buffer.entrySet()) {
                TraceAggregationBuffer buffer = entry.getValue();
                TraceEventRecords record = buffer.getTraceEventRecords();
                record.setCount(buffer.getCount());
                super.deliver(OUTPUT_PORT_NAME_TRACES, record);
            }
            this.trace2buffer.clear();
        }
    }

    private void processTimeoutQueue(long timestamp) {
        long bufferTimeout = timestamp - this.maxCollectionDuration;
        Iterator<Map.Entry<TraceEventRecords, TraceAggregationBuffer>> iterator = this.trace2buffer.entrySet().iterator();
        while (iterator.hasNext()) {
            TraceAggregationBuffer traceBuffer = iterator.next().getValue();
            if (traceBuffer.getBufferCreatedTimestamp() <= bufferTimeout) {
                TraceEventRecords record = traceBuffer.getTraceEventRecords();
                record.setCount(traceBuffer.getCount());
                super.deliver(OUTPUT_PORT_NAME_TRACES, record);
            }
            iterator.remove();
        }
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_TIMEUNIT, this.timeunit.name());
        configuration.setProperty(CONFIG_PROPERTY_NAME_MAX_COLLECTION_DURATION, String.valueOf(this.maxCollectionDuration));
        return configuration;
    }

    private static final class TraceComperator
    implements Comparator<TraceEventRecords>,
    Serializable {
        private static final long serialVersionUID = 8920766818232517L;

        @Override
        public int compare(TraceEventRecords t1, TraceEventRecords t2) {
            AbstractTraceEvent[] recordsT2;
            AbstractTraceEvent[] recordsT1 = t1.getTraceEvents();
            if (recordsT1.length != (recordsT2 = t2.getTraceEvents()).length) {
                return recordsT1.length - recordsT2.length;
            }
            int cmpHostnames = t1.getTraceMetadata().getHostname().compareTo(t2.getTraceMetadata().getHostname());
            if (cmpHostnames != 0) {
                return cmpHostnames;
            }
            for (int i = 0; i < recordsT1.length; ++i) {
                int cmpError;
                int cmpSignature;
                AbstractTraceEvent recordT1 = recordsT1[i];
                AbstractTraceEvent recordT2 = recordsT2[i];
                int cmpClass = recordT1.getClass().getName().compareTo(recordT2.getClass().getName());
                if (cmpClass != 0) {
                    return cmpClass;
                }
                if (recordT1 instanceof AbstractOperationEvent && (cmpSignature = ((AbstractOperationEvent)recordT1).getOperationSignature().compareTo(((AbstractOperationEvent)recordT2).getOperationSignature())) != 0) {
                    return cmpSignature;
                }
                if (!(recordT1 instanceof AfterOperationFailedEvent) || (cmpError = ((AfterOperationFailedEvent)recordT1).getCause().compareTo(((AfterOperationFailedEvent)recordT2).getCause())) == 0) continue;
                return cmpClass;
            }
            return 0;
        }
    }

    private static final class TraceAggregationBuffer {
        private final long bufferCreatedTimestamp;
        private final TraceEventRecords aggregatedTrace;
        private int countOfAggregatedTraces;

        public TraceAggregationBuffer(long bufferCreatedTimestamp, TraceEventRecords trace) {
            this.bufferCreatedTimestamp = bufferCreatedTimestamp;
            this.aggregatedTrace = trace;
        }

        public void count() {
            ++this.countOfAggregatedTraces;
        }

        public long getBufferCreatedTimestamp() {
            return this.bufferCreatedTimestamp;
        }

        public TraceEventRecords getTraceEventRecords() {
            return this.aggregatedTrace;
        }

        public int getCount() {
            return this.countOfAggregatedTraces;
        }
    }
}

