/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.forward;

import java.util.concurrent.atomic.AtomicLong;
import kieker.analysis.IProjectContext;
import kieker.analysis.display.PlainText;
import kieker.analysis.display.annotation.Display;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;

@Plugin(description="A filter computing the throughput of the analysis", outputPorts={@OutputPort(name="relayedEvents", eventTypes={Object.class}, description="Provides each incoming object"), @OutputPort(name="throughput", eventTypes={Long.class}, description="Provides throughput since last timer event object")})
public class AnalysisThroughputFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_OBJECTS = "inputObjects";
    public static final String INPUT_PORT_NAME_TIME = "inputTime";
    public static final String OUTPUT_PORT_NAME_RELAYED_OBJECTS = "relayedEvents";
    public static final String OUTPUT_PORT_NAME_THROUGHPUT = "throughput";
    private final AtomicLong counter = new AtomicLong();
    private final PlainText plainTextDisplayObject = new PlainText();
    private volatile long lastTimestamp;

    public AnalysisThroughputFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return new Configuration();
    }

    @InputPort(name="inputObjects", eventTypes={Object.class}, description="Receives incoming objects to calculate the throughput")
    public final void inputObjects(Object object) {
        this.counter.incrementAndGet();
        super.deliver(OUTPUT_PORT_NAME_RELAYED_OBJECTS, object);
    }

    @InputPort(name="inputTime", eventTypes={Long.class}, description="Receives timestamps to calculate the throughput")
    public final void inputTime(Long timestamp) {
        long count = this.counter.getAndSet(0L);
        long duration = timestamp - this.lastTimestamp;
        StringBuilder sb = new StringBuilder(256);
        sb.append(count).append(" objects within ").append(duration).append(' ').append(this.recordsTimeUnitFromProjectContext.toString());
        this.plainTextDisplayObject.setText(sb.toString());
        super.deliver(OUTPUT_PORT_NAME_THROUGHPUT, count);
        this.lastTimestamp = timestamp;
    }

    @Display(name="Throughput Display")
    public final PlainText plainTextDisplay() {
        return this.plainTextDisplayObject;
    }
}

