/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.forward;

import java.util.concurrent.atomic.AtomicLong;
import kieker.analysis.IProjectContext;
import kieker.analysis.display.PlainText;
import kieker.analysis.display.XYPlot;
import kieker.analysis.display.annotation.Display;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;

@Plugin(description="A filter counting the elements flowing through this filter", outputPorts={@OutputPort(name="relayedEvents", eventTypes={Object.class}, description="Provides each incoming object"), @OutputPort(name="currentEventCount", eventTypes={Long.class}, description="Provides the current object count")})
public final class CountingFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EVENTS = "inputEvents";
    public static final String OUTPUT_PORT_NAME_RELAYED_EVENTS = "relayedEvents";
    public static final String OUTPUT_PORT_NAME_COUNT = "currentEventCount";
    private final AtomicLong counter = new AtomicLong();
    private volatile long timeStampOfInitialization;
    private final PlainText plainText = new PlainText();
    private final XYPlot xyPlot = new XYPlot(50);

    public CountingFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @Override
    public final Configuration getCurrentConfiguration() {
        return new Configuration();
    }

    public final long getMessageCount() {
        return this.counter.get();
    }

    @InputPort(name="inputEvents", eventTypes={Object.class}, description="Receives incoming objects to be counted and forwarded")
    public final void inputEvent(Object event) {
        Long count = this.counter.incrementAndGet();
        this.updateDisplays();
        super.deliver(OUTPUT_PORT_NAME_RELAYED_EVENTS, event);
        super.deliver(OUTPUT_PORT_NAME_COUNT, count);
    }

    private void updateDisplays() {
        long timeStampDeltaInSeconds = (System.currentTimeMillis() - this.timeStampOfInitialization) / 1000L;
        this.xyPlot.setEntry("", timeStampDeltaInSeconds, this.counter.get());
        this.plainText.setText(Long.toString(this.counter.get()));
    }

    @Override
    public boolean init() {
        if (super.init()) {
            this.timeStampOfInitialization = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Display(name="Counter Display")
    public final PlainText plainTextDisplay() {
        return this.plainText;
    }

    @Display(name="XYPlot Counter Display")
    public final XYPlot xyPlotDisplay() {
        return this.xyPlot;
    }
}

