/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.sink;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.display.XYPlot;
import kieker.analysis.display.annotation.Display;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.jvm.GCRecord;

@Plugin(configuration={@Property(name="numberOfEntries", defaultValue="100", description="Sets the number of max plot entries per record entry")})
public class GCDisplayFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EVENTS = "inputEvents";
    public static final String CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES = "numberOfEntries";
    public static final String CONFIG_PROPERTY_VALUE_NUMBER_OF_ENTRIES = "100";
    private static final String COLLECTION_TIME = "Collection Time";
    private static final String COLLECTION_COUNT = "Collection Count";
    private final XYPlot xyplot;
    private final int numberOfEntries;

    public GCDisplayFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.numberOfEntries = configuration.getIntProperty(CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES);
        this.xyplot = new XYPlot(this.numberOfEntries);
    }

    @InputPort(name="inputEvents", eventTypes={GCRecord.class})
    public void input(GCRecord record) {
        this.updateDisplays(record);
    }

    private void updateDisplays(GCRecord record) {
        Date date = new Date(TimeUnit.MILLISECONDS.convert(record.getLoggingTimestamp(), this.recordsTimeUnitFromProjectContext));
        String minutesAndSeconds = date.toString().substring(14, 19);
        String id = record.getHostname() + " - " + record.getVmName() + " - " + record.getGcName();
        this.xyplot.setEntry(id + " - " + COLLECTION_COUNT, minutesAndSeconds, record.getCollectionCount());
        this.xyplot.setEntry(id + " - " + COLLECTION_TIME, minutesAndSeconds, record.getCollectionTimeMS());
    }

    @Display(name="XYPlot Display")
    public XYPlot getXYPlot() {
        return this.xyplot;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES, String.valueOf(this.numberOfEntries));
        return configuration;
    }
}

