/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.classpath.InstantiationFactory;

@Plugin(description="A reader which reads records from a database", outputPorts={@OutputPort(name="monitoringRecords", eventTypes={IMonitoringRecord.class}, description="Output Port of the DBReader")}, configuration={@Property(name="DriverClassname", defaultValue="org.apache.derby.jdbc.EmbeddedDriver", description="The classname of the driver used for the connection."), @Property(name="ConnectionString", defaultValue="jdbc:derby:tmp/KIEKER;user=DBUSER;password=DBPASS", description="The connection string used to establish the connection."), @Property(name="TablePrefix", defaultValue="kieker", description="The prefix of the used table within the database.")})
public class DbReader
extends AbstractReaderPlugin {
    public static final String OUTPUT_PORT_NAME_RECORDS = "monitoringRecords";
    public static final String CONFIG_PROPERTY_NAME_DRIVERCLASSNAME = "DriverClassname";
    public static final String CONFIG_PROPERTY_NAME_CONNECTIONSTRING = "ConnectionString";
    public static final String CONFIG_PROPERTY_NAME_TABLEPREFIX = "TablePrefix";
    private final String driverClassname;
    private final String connectionString;
    private final String tablePrefix;
    private volatile boolean running = true;

    public DbReader(Configuration configuration, IProjectContext projectContext) throws Exception {
        super(configuration, projectContext);
        this.driverClassname = configuration.getStringProperty(CONFIG_PROPERTY_NAME_DRIVERCLASSNAME);
        this.connectionString = configuration.getStringProperty(CONFIG_PROPERTY_NAME_CONNECTIONSTRING);
        this.tablePrefix = configuration.getStringProperty(CONFIG_PROPERTY_NAME_TABLEPREFIX);
        try {
            Class.forName(this.driverClassname).newInstance();
        }
        catch (Exception ex) {
            throw new Exception("DB driver registration failed. Perhaps the driver jar is missing?", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean read() {
        Connection connection = null;
        connection = DriverManager.getConnection(this.connectionString);
        try (Statement getIndexTable = null;){
            getIndexTable = connection.createStatement();
            try (ResultSet indexTable = null;){
                indexTable = getIndexTable.executeQuery("SELECT * from " + this.tablePrefix);
                while (this.running && indexTable.next()) {
                    String tablename = indexTable.getString(1);
                    String classname = indexTable.getString(2);
                    try {
                        this.table2record(connection, tablename, AbstractMonitoringRecord.classForName(classname));
                    }
                    catch (MonitoringRecordException ex) {
                        this.logger.error("Failed to load records of type {} from table {}", (Object)classname, (Object)tablename);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.error("Failed to load records of type {}. exception {}", (Object)classname, (Object)e);
                    }
                    catch (IllegalAccessException e) {
                        this.logger.error("TYPES field of class {} cannot be access", (Object)classname);
                    }
                    catch (NoSuchFieldException e) {
                        this.logger.error("Class {} does not have a TYPES field; is not a proper Kieker record", (Object)classname);
                    }
                    catch (SecurityException e) {
                        this.logger.error("Class {} in accessible", (Object)classname);
                    }
                }
            }
        }
        if (connection == null) return true;
        try {
            connection.close();
            return true;
        }
        catch (SQLException ex) {
            this.logger.error("SQLException with SQLState: '{}' and VendorError: '{}'", new Object[]{ex.getSQLState(), ex.getErrorCode(), ex});
        }
        return true;
        catch (SQLException ex) {
            boolean bl;
            try {
                this.logger.error("SQLException with SQLState: '{}' and VendorError: '{}'", new Object[]{ex.getSQLState(), ex.getErrorCode(), ex});
                bl = false;
                if (connection == null) return bl;
            }
            catch (Throwable throwable) {
                if (connection == null) throw throwable;
                try {
                    connection.close();
                    throw throwable;
                }
                catch (SQLException ex2) {
                    this.logger.error("SQLException with SQLState: '{}' and VendorError: '{}'", new Object[]{ex2.getSQLState(), ex2.getErrorCode(), ex2});
                }
                throw throwable;
            }
            try {
                connection.close();
                return bl;
            }
            catch (SQLException ex3) {
                this.logger.error("SQLException with SQLState: '{}' and VendorError: '{}'", new Object[]{ex3.getSQLState(), ex3.getErrorCode(), ex3});
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void table2record(Connection connection, String tablename, Class<? extends IMonitoringRecord> clazz) throws SQLException, MonitoringRecordException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        try (Statement selectRecord = null;){
            selectRecord = connection.createStatement();
            try (ResultSet records = null;){
                records = selectRecord.executeQuery("SELECT * from " + tablename);
                int size = records.getMetaData().getColumnCount() - 2;
                while (this.running && records.next()) {
                    Object[] recordValues = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        recordValues[i] = records.getObject(i + 3);
                    }
                    Class[] parameterTypes = (Class[])clazz.getField("TYPES").get(null);
                    IMonitoringRecord record = InstantiationFactory.getInstance(null).create(IMonitoringRecord.class, clazz.getCanonicalName(), parameterTypes, recordValues);
                    record.setLoggingTimestamp(records.getLong(2));
                    super.deliver(OUTPUT_PORT_NAME_RECORDS, record);
                }
            }
        }
    }

    @Override
    public void terminate(boolean error) {
        this.logger.info("Shutdown of DBReader requested.");
        this.running = false;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_DRIVERCLASSNAME, this.driverClassname);
        configuration.setProperty(CONFIG_PROPERTY_NAME_CONNECTIONSTRING, this.connectionString);
        configuration.setProperty(CONFIG_PROPERTY_NAME_TABLEPREFIX, this.tablePrefix);
        return configuration;
    }
}

