/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.source.file;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.stream.Stream;
import kieker.analysis.plugin.reader.depcompression.AbstractDecompressionFilter;
import kieker.analysis.plugin.reader.depcompression.Bzip2DecompressionFilter;
import kieker.analysis.plugin.reader.depcompression.DeflateDecompressionFilter;
import kieker.analysis.plugin.reader.depcompression.GZipDecompressionFilter;
import kieker.analysis.plugin.reader.depcompression.NoneDecompressionFilter;
import kieker.analysis.plugin.reader.depcompression.XZDecompressionFilter;
import kieker.analysis.plugin.reader.depcompression.ZipDecompressionFilter;
import kieker.analysis.plugin.reader.util.FSReaderUtil;
import kieker.analysis.source.file.AbstractEventDeserializer;
import kieker.analysis.source.file.AbstractMapDeserializer;
import kieker.analysis.source.file.MapFileFilter;
import kieker.common.record.IMonitoringRecord;
import kieker.common.registry.reader.ReaderRegistry;
import teetime.framework.OutputPort;
import teetime.stage.basic.AbstractTransformation;

public class DirectoryReaderStage
extends AbstractTransformation<File, IMonitoringRecord> {
    private final FilenameFilter mapFilter = new MapFileFilter();
    private final Integer dataBufferSize;
    private final boolean verbose;

    public DirectoryReaderStage(boolean verbose, int dataBufferSize) {
        this.verbose = verbose;
        this.dataBufferSize = dataBufferSize;
    }

    protected void execute(File directory) {
        ReaderRegistry<String> registry = new ReaderRegistry<String>();
        File[] mapFiles = directory.listFiles(this.mapFilter);
        if (mapFiles == null) {
            this.logger.error("{} is not a proper directory.", (Object)directory.getAbsolutePath());
        } else {
            for (File mapFile : mapFiles) {
                String mapFileName = mapFile.getName();
                try (InputStream inputStream = Files.newInputStream(mapFile.toPath(), StandardOpenOption.READ);){
                    this.readMapFile(inputStream, mapFileName, registry);
                }
                catch (IOException e) {
                    this.logger.error("Cannot find map file {}.", (Object)mapFileName);
                }
            }
            try (Stream<Path> stream = Files.list(directory.toPath());){
                stream.sorted().forEach(logFilePath -> {
                    File logFile = logFilePath.toFile();
                    String logFileName = logFile.getName();
                    try (InputStream inputStream = Files.newInputStream(logFile.toPath(), StandardOpenOption.READ);){
                        this.readLogFile(inputStream, logFileName, registry);
                    }
                    catch (IOException e) {
                        this.logger.error("Cannot find log file {}.", (Object)logFileName);
                    }
                });
            }
            catch (IOException e1) {
                this.logger.error("Cannot process directory {}", (Object)directory.getAbsolutePath());
            }
        }
    }

    private AbstractDecompressionFilter findDecompressionFilterByExtension(String filename) {
        String extension = FSReaderUtil.getExtension(filename);
        if (".gz".equals(extension)) {
            return new GZipDecompressionFilter();
        }
        if (".df".equals(extension)) {
            return new DeflateDecompressionFilter();
        }
        if (".xz".equals(extension)) {
            return new XZDecompressionFilter();
        }
        if (".zip".equals(extension)) {
            return new ZipDecompressionFilter();
        }
        if (".bz2".equals(extension)) {
            return new Bzip2DecompressionFilter();
        }
        return new NoneDecompressionFilter();
    }

    private void readMapFile(InputStream inputStream, String mapFileName, ReaderRegistry<String> registry) {
        Class<? extends AbstractMapDeserializer> deserializerClass;
        AbstractDecompressionFilter decompressionFilter = this.findDecompressionFilterByExtension(mapFileName);
        this.logger.debug("Reading map file {}", (Object)mapFileName);
        if (decompressionFilter instanceof NoneDecompressionFilter) {
            deserializerClass = FSReaderUtil.findMapDeserializer(mapFileName);
        } else {
            String baseName = mapFileName.substring(0, mapFileName.lastIndexOf(46) - 1);
            deserializerClass = FSReaderUtil.findMapDeserializer(baseName);
        }
        try (InputStream chainedInputStream = decompressionFilter.chainInputStream(inputStream);){
            try {
                AbstractMapDeserializer deserializer = deserializerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                deserializer.processDataStream(decompressionFilter.chainInputStream(inputStream), registry, mapFileName);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.logger.error("Cannot instantiate filter {} for decompression.", (Object)deserializerClass.getName());
            }
        }
        catch (IOException ex) {
            this.logger.error("Reading map file {} failed.", (Object)mapFileName);
        }
    }

    private void readLogFile(InputStream inputStream, String logFileName, ReaderRegistry<String> registry) {
        Class<? extends AbstractEventDeserializer> deserializerClass;
        AbstractDecompressionFilter decompressionFilter = this.findDecompressionFilterByExtension(logFileName);
        if (this.verbose) {
            this.logger.info("Reading log file {}", (Object)logFileName);
        } else {
            this.logger.debug("Reading log file {}", (Object)logFileName);
        }
        if (decompressionFilter instanceof NoneDecompressionFilter) {
            deserializerClass = FSReaderUtil.findEventDeserializer(logFileName);
        } else {
            String baseName = logFileName.substring(0, logFileName.lastIndexOf(46));
            deserializerClass = FSReaderUtil.findEventDeserializer(baseName);
        }
        if (deserializerClass != null) {
            try (InputStream chainedInputStream = decompressionFilter.chainInputStream(inputStream);){
                try {
                    AbstractEventDeserializer deserializer = deserializerClass.getConstructor(Integer.class, ReaderRegistry.class).newInstance(this.dataBufferSize, registry);
                    deserializer.processDataStream(chainedInputStream, (OutputPort<IMonitoringRecord>)this.outputPort);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    this.logger.error("Cannot instantiate filter {} for decompression.", (Object)deserializerClass.getName());
                }
            }
            catch (IOException e) {
                this.logger.error("Reading log file {} failed.", (Object)logFileName);
            }
        } else {
            this.logger.debug("Skipping file {}, as the extension indicates that it is not a log file.", (Object)logFileName);
        }
    }
}

