/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.source.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import kieker.analysis.source.file.AbstractMapDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import kieker.common.util.filesystem.FSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextMapDeserializer
extends AbstractMapDeserializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextMapDeserializer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDataStream(InputStream inputStream, ReaderRegistry<String> registry, String mapFileName) {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = in.readLine()) != null) {
                if (line.length() == 0) continue;
                LOGGER.debug("Read line: {}", (Object)line);
                int split = line.indexOf(61);
                if (split == -1) {
                    LOGGER.error("Failed to parse line: {} from file {}. Each line must contain ID=VALUE pairs.", (Object)line, (Object)mapFileName);
                    continue;
                }
                this.registerEntry(registry, line.substring(0, split), line.substring(split + 1));
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading {}", (Object)mapFileName, (Object)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOGGER.error("Exception while closing input stream for mapping file", (Throwable)ex);
                }
            }
        }
    }

    private void registerEntry(ReaderRegistry<String> registry, String key, String value) {
        Integer id;
        try {
            id = Integer.valueOf(key.charAt(0) == '$' ? key.substring(1) : key);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Error reading mapping file, id must be integer", (Throwable)ex);
            return;
        }
        String prevVal = registry.register(id.intValue(), FSUtil.decodeNewline(value));
        if (prevVal != null) {
            LOGGER.error("Found additional entry for id='{}', old value was '{}' new value is '{}'", new Object[]{id, prevVal, value});
        }
    }
}

