/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.source.rewriter;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kieker.analysis.source.rewriter.ITraceMetadataRewriter;
import kieker.analysis.source.tcp.Connection;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.flow.ITraceRecord;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.misc.KiekerMetadataRecord;
import teetime.framework.OutputPort;

public class PlainTraceMetadataRewriter
implements ITraceMetadataRewriter {
    private volatile AtomicLong traceId = new AtomicLong();
    private final Map<String, Map<Long, TraceMetadata>> metadatamap = new HashMap<String, Map<Long, TraceMetadata>>();

    @Override
    public void rewrite(Connection connection, IMonitoringRecord record, long loggingTimestamp, OutputPort<IMonitoringRecord> outputPort) throws IOException {
        record.setLoggingTimestamp(loggingTimestamp);
        if (record instanceof TraceMetadata) {
            TraceMetadata traceMetadata = (TraceMetadata)record;
            traceMetadata.setTraceId(this.traceId.get());
            Map<Long, TraceMetadata> map = this.metadatamap.get(traceMetadata.getHostname());
            if (map == null) {
                map = new HashMap<Long, TraceMetadata>();
                this.metadatamap.put(traceMetadata.getHostname(), map);
            }
            map.put(traceMetadata.getTraceId(), traceMetadata);
            this.traceId.incrementAndGet();
            outputPort.send((Object)traceMetadata);
        } else if (record instanceof ITraceRecord) {
            SocketAddress remoteAddress = connection.getChannel().getRemoteAddress();
            String ip = this.getIP(remoteAddress);
            long inputTraceId = ((ITraceRecord)record).getTraceId();
            Map<Long, TraceMetadata> map = this.metadatamap.get(ip);
            if (map != null) {
                TraceMetadata metaData = map.get(inputTraceId);
                ((ITraceRecord)record).setTraceId(metaData.getTraceId());
                outputPort.send((Object)record);
            }
        } else if (!(record instanceof KiekerMetadataRecord)) {
            outputPort.send((Object)record);
        }
    }

    private String getIP(SocketAddress remoteAddress) {
        InetSocketAddress sockaddr = (InetSocketAddress)remoteAddress;
        return sockaddr.getHostString();
    }
}

