/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.source.time;

import java.util.concurrent.TimeUnit;
import teetime.framework.AbstractProducerStage;

public class TimeSourceStage
extends AbstractProducerStage<Long> {
    private final long delay;
    private final TimeUnit timeunit = TimeUnit.NANOSECONDS;
    private final long numberOfImpulses;
    private final boolean infinite;

    public TimeSourceStage(long delay, Long numberOfImpulses) {
        this.delay = delay;
        this.numberOfImpulses = numberOfImpulses == null ? 0L : numberOfImpulses;
        this.infinite = numberOfImpulses == null;
    }

    protected void execute() throws Exception {
        while (this.repeatEvent()) {
            long timestamp = this.timeunit.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
            this.outputPort.send((Object)timestamp);
            Thread.sleep(this.delay / 1000L / 1000L);
        }
        this.workCompleted();
    }

    private boolean repeatEvent() {
        if (this.shouldBeTerminated()) {
            return false;
        }
        if (this.infinite) {
            return true;
        }
        return this.numberOfImpulses > 0L;
    }
}

