/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.time.events;

import kieker.analysis.time.events.AbstractCurrentTimeEventGenerationFilter;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.TimestampRecord;

public class RecordCurrentTimeEventGenerationFilter
extends AbstractCurrentTimeEventGenerationFilter<IMonitoringRecord> {
    public RecordCurrentTimeEventGenerationFilter(long timerResolution) {
        super(timerResolution);
    }

    @Override
    protected void execute(IMonitoringRecord record) {
        long timestamp = record.getLoggingTimestamp();
        if (timestamp < 0L) {
            this.logger.warn("Received timestamp value < 0: " + timestamp);
            return;
        }
        if (this.firstTimestamp == -1L) {
            this.maxTimestamp = timestamp;
            this.firstTimestamp = timestamp;
            this.currentTimeRecordOutputPort.send((Object)new TimestampRecord(timestamp));
            this.currentTimeValueOutputPort.send((Object)timestamp);
            this.mostRecentEventFired = timestamp;
        } else if (timestamp > this.maxTimestamp) {
            this.maxTimestamp = timestamp;
            long nextTimerEventAt = this.mostRecentEventFired + this.timerResolution;
            while (timestamp >= nextTimerEventAt) {
                this.currentTimeRecordOutputPort.send((Object)new TimestampRecord(nextTimerEventAt));
                this.currentTimeValueOutputPort.send((Object)nextTimerEventAt);
                this.mostRecentEventFired = nextTimerEventAt;
                nextTimerEventAt = this.mostRecentEventFired + this.timerResolution;
            }
        }
    }
}

