/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.trace.sink;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kieker.analysis.trace.AbstractTraceProcessingStage;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.ExecutionTrace;

public class ExecutionTraceWriterFilter
extends AbstractTraceProcessingStage<ExecutionTrace> {
    private static final String ENCODING = "UTF-8";
    private final String outputFilename;
    private final PrintStream printStream;
    private final OutputStream stream;

    public ExecutionTraceWriterFilter(SystemModelRepository repository, File outputFile) throws IOException {
        super(repository);
        this.outputFilename = outputFile.getCanonicalPath();
        this.stream = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);
        this.printStream = new PrintStream(this.stream, false, ENCODING);
    }

    @Override
    public void printStatusMessage() {
        super.printStatusMessage();
        int numTraces = this.getSuccessCount();
        this.logger.debug("Wrote {} execution trace{} to file '{}'", new Object[]{numTraces, numTraces > 1 ? "s" : "", this.outputFilename});
    }

    protected void onTerminating() {
        this.logger.debug("Terminating {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        if (this.printStream != null) {
            try {
                this.printStream.flush();
                this.stream.flush();
                this.printStream.close();
                this.stream.close();
            }
            catch (IOException e) {
                this.logger.error("Cannot write execution trace: {}", (Object)e.getLocalizedMessage());
            }
        }
        super.onTerminating();
    }

    protected void execute(ExecutionTrace executionTrace) {
        this.logger.debug("size {}", (Object)executionTrace.getLength());
        String data = executionTrace.toString();
        this.printStream.println(data);
        this.printStream.flush();
        this.reportSuccess(executionTrace.getTraceId());
    }
}

