/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.trace.sink;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kieker.analysis.trace.AbstractTraceProcessingStage;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.MessageTrace;

public class MessageTraceWriterFilter
extends AbstractTraceProcessingStage<MessageTrace> {
    private static final String ENCODING = "UTF-8";
    private final String outputFilename;
    private final PrintStream printStream;

    public MessageTraceWriterFilter(SystemModelRepository repository, File outputFile) throws IOException {
        super(repository);
        this.outputFilename = outputFile.getCanonicalPath();
        this.printStream = new PrintStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), false, ENCODING);
    }

    @Override
    public void printStatusMessage() {
        super.printStatusMessage();
        int numTraces = this.getSuccessCount();
        this.logger.debug("Wrote {} trace{} to file '{}'", new Object[]{numTraces, numTraces > 1 ? "s" : "", this.outputFilename});
    }

    protected void onTerminating() {
        this.logger.debug("Terminatiing {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        if (this.printStream != null) {
            this.printStream.close();
        }
        super.onTerminating();
    }

    protected void execute(MessageTrace messageTrace) throws Exception {
        this.printStream.println(messageTrace.toString());
        this.reportSuccess(messageTrace.getTraceId());
    }
}

