/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.database;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.flow.IClassSignature;
import kieker.common.record.flow.IEventRecord;
import kieker.common.record.flow.IFlowRecord;
import kieker.common.record.flow.ITraceRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class BeforeDatabaseEvent
extends AbstractMonitoringRecord
implements IEventRecord,
IFlowRecord,
IClassSignature,
ITraceRecord {
    public static final int SIZE = 32;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, Long.TYPE, Integer.TYPE, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "classSignature", "traceId", "orderIndex", "parameters", "technology"};
    public static final long TIMESTAMP = 0L;
    public static final String CLASS_SIGNATURE = "";
    public static final long TRACE_ID = -1L;
    public static final int ORDER_INDEX = -1;
    public static final String PARAMETERS = "";
    public static final String TECHNOLOGY = "";
    private static final long serialVersionUID = 3457043370101594469L;
    private long timestamp;
    private final String classSignature;
    private long traceId;
    private final int orderIndex;
    private final String parameters;
    private final String technology;

    public BeforeDatabaseEvent(long timestamp, String classSignature, long traceId, int orderIndex, String parameters, String technology) {
        this.timestamp = timestamp;
        this.classSignature = classSignature == null ? "" : classSignature;
        this.traceId = traceId;
        this.orderIndex = orderIndex;
        this.parameters = parameters == null ? "" : parameters;
        this.technology = technology == null ? "" : technology;
    }

    public BeforeDatabaseEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.classSignature = deserializer.getString();
        this.traceId = deserializer.getLong();
        this.orderIndex = deserializer.getInt();
        this.parameters = deserializer.getString();
        this.technology = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getClassSignature());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getParameters());
        serializer.putString(this.getTechnology());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 32;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BeforeDatabaseEvent castedRecord = (BeforeDatabaseEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (!this.getClassSignature().equals(castedRecord.getClassSignature())) {
            return false;
        }
        if (this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        if (this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getParameters().equals(castedRecord.getParameters())) {
            return false;
        }
        return this.getTechnology().equals(castedRecord.getTechnology());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getClassSignature().hashCode();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        code += this.getParameters().hashCode();
        return code += this.getTechnology().hashCode();
    }

    @Override
    public final long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public final void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public final String getClassSignature() {
        return this.classSignature;
    }

    @Override
    public final long getTraceId() {
        return this.traceId;
    }

    @Override
    public final void setTraceId(long traceId) {
        this.traceId = traceId;
    }

    @Override
    public final int getOrderIndex() {
        return this.orderIndex;
    }

    public final String getParameters() {
        return this.parameters;
    }

    public final String getTechnology() {
        return this.technology;
    }

    @Override
    public String toString() {
        String result = "BeforeDatabaseEvent: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "classSignature = ";
        result = result + this.getClassSignature() + ", ";
        result = result + "traceId = ";
        result = result + this.getTraceId() + ", ";
        result = result + "orderIndex = ";
        result = result + this.getOrderIndex() + ", ";
        result = result + "parameters = ";
        result = result + this.getParameters() + ", ";
        result = result + "technology = ";
        result = result + this.getTechnology() + ", ";
        return result;
    }
}

