/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.factory;

import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.util.classpath.ClassForNameResolver;

public class RecordFactoryResolver {
    private final ClassForNameResolver<IRecordFactory> classForNameResolver = new ClassForNameResolver<IRecordFactory>(IRecordFactory.class);

    private String buildRecordFactoryClassName(String recordClassName) {
        return recordClassName + "Factory";
    }

    public IRecordFactory<? extends IMonitoringRecord> get(String recordClassName) {
        String recordFactoryClassName = this.buildRecordFactoryClassName(recordClassName);
        try {
            Class<IRecordFactory> recordFactoryClass = this.classForNameResolver.classForName(recordFactoryClassName);
            return recordFactoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

