/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.thread;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.thread.AbstractThreadBasedEvent;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class BeforeThreadBasedEvent
extends AbstractThreadBasedEvent {
    public static final int SIZE = 28;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "threadId", "orderIndex", "operationSignature", "classSignature"};
    private static final long serialVersionUID = 5925125427812994180L;

    public BeforeThreadBasedEvent(long timestamp, long threadId, int orderIndex, String operationSignature, String classSignature) {
        super(timestamp, threadId, orderIndex, operationSignature, classSignature);
    }

    public BeforeThreadBasedEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getThreadId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getOperationSignature());
        serializer.putString(this.getClassSignature());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 28;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BeforeThreadBasedEvent castedRecord = (BeforeThreadBasedEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (this.getThreadId() != castedRecord.getThreadId()) {
            return false;
        }
        if (this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        return this.getClassSignature().equals(castedRecord.getClassSignature());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getThreadId();
        code += this.getOrderIndex();
        code += this.getOperationSignature().hashCode();
        return code += this.getClassSignature().hashCode();
    }

    @Override
    public String toString() {
        String result = "BeforeThreadBasedEvent: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "threadId = ";
        result = result + this.getThreadId() + ", ";
        result = result + "orderIndex = ";
        result = result + this.getOrderIndex() + ", ";
        result = result + "operationSignature = ";
        result = result + this.getOperationSignature() + ", ";
        result = result + "classSignature = ";
        result = result + this.getClassSignature() + ", ";
        return result;
    }
}

