/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class ApplicationTraceMetadata
extends TraceMetadata {
    public static final int SIZE = 40;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Long.TYPE, Integer.TYPE, String.class};
    public static final String NO_APPLICATION_NAME = "<no-application-name>";
    public static final String[] VALUE_NAMES = new String[]{"traceId", "threadId", "sessionId", "hostname", "parentTraceId", "parentOrderId", "applicationName"};
    public static final String APPLICATION_NAME = "<no-application-name>";
    private static final long serialVersionUID = 7720995073835113293L;
    private final String applicationName;

    public ApplicationTraceMetadata(long traceId, long threadId, String sessionId, String hostname, long parentTraceId, int parentOrderId, String applicationName) {
        super(traceId, threadId, sessionId, hostname, parentTraceId, parentOrderId);
        this.applicationName = applicationName == null ? "<no-application-name>" : applicationName;
    }

    public ApplicationTraceMetadata(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.applicationName = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTraceId());
        serializer.putLong(this.getThreadId());
        serializer.putString(this.getSessionId());
        serializer.putString(this.getHostname());
        serializer.putLong(this.getParentTraceId());
        serializer.putInt(this.getParentOrderId());
        serializer.putString(this.getApplicationName());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 40;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ApplicationTraceMetadata castedRecord = (ApplicationTraceMetadata)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        if (this.getThreadId() != castedRecord.getThreadId()) {
            return false;
        }
        if (!this.getSessionId().equals(castedRecord.getSessionId())) {
            return false;
        }
        if (!this.getHostname().equals(castedRecord.getHostname())) {
            return false;
        }
        if (this.getParentTraceId() != castedRecord.getParentTraceId()) {
            return false;
        }
        if (this.getParentOrderId() != castedRecord.getParentOrderId()) {
            return false;
        }
        if (this.getNextOrderId() != castedRecord.getNextOrderId()) {
            return false;
        }
        return this.getApplicationName().equals(castedRecord.getApplicationName());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTraceId();
        code += (int)this.getThreadId();
        code += this.getSessionId().hashCode();
        code += this.getHostname().hashCode();
        code += (int)this.getParentTraceId();
        code += this.getParentOrderId();
        code += this.getNextOrderId();
        return code += this.getApplicationName().hashCode();
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String toString() {
        String result = "ApplicationTraceMetadata: ";
        result = result + "traceId = ";
        result = result + this.getTraceId() + ", ";
        result = result + "threadId = ";
        result = result + this.getThreadId() + ", ";
        result = result + "sessionId = ";
        result = result + this.getSessionId() + ", ";
        result = result + "hostname = ";
        result = result + this.getHostname() + ", ";
        result = result + "parentTraceId = ";
        result = result + this.getParentTraceId() + ", ";
        result = result + "parentOrderId = ";
        result = result + this.getParentOrderId() + ", ";
        result = result + "applicationName = ";
        result = result + this.getApplicationName() + ", ";
        return result;
    }
}

