/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.concurrency;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class JoinEvent
extends AbstractTraceEvent {
    public static final int SIZE = 28;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "traceId", "orderIndex", "joinedTraceId"};
    public static final long JOINED_TRACE_ID = 0L;
    private static final long serialVersionUID = 5699964259392184696L;
    private final long joinedTraceId;

    public JoinEvent(long timestamp, long traceId, int orderIndex, long joinedTraceId) {
        super(timestamp, traceId, orderIndex);
        this.joinedTraceId = joinedTraceId;
    }

    public JoinEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.joinedTraceId = deserializer.getLong();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putLong(this.getJoinedTraceId());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 28;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        JoinEvent castedRecord = (JoinEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        if (this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        return this.getJoinedTraceId() == castedRecord.getJoinedTraceId();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        return code += (int)this.getJoinedTraceId();
    }

    public final long getJoinedTraceId() {
        return this.joinedTraceId;
    }

    @Override
    public String toString() {
        String result = "JoinEvent: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "traceId = ";
        result = result + this.getTraceId() + ", ";
        result = result + "orderIndex = ";
        result = result + this.getOrderIndex() + ", ";
        result = result + "joinedTraceId = ";
        result = result + this.getJoinedTraceId() + ", ";
        return result;
    }
}

