/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.io;

import java.nio.ByteBuffer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.registry.writer.IWriterRegistry;

public class BinaryValueSerializer
implements IValueSerializer {
    private static final byte TRUE_VALUE = 1;
    private static final byte FALSE_VALUE = 0;
    private final ByteBuffer buffer;
    private final IWriterRegistry<String> stringRegistry;

    protected BinaryValueSerializer(ByteBuffer buffer, IWriterRegistry<String> stringRegistry) {
        this.buffer = buffer;
        this.stringRegistry = stringRegistry;
    }

    public static BinaryValueSerializer create(ByteBuffer buffer, IWriterRegistry<String> stringRegistry) {
        return new BinaryValueSerializer(buffer, stringRegistry);
    }

    @Override
    public void putBoolean(boolean value) {
        byte data = value ? (byte)1 : 0;
        this.putByte(data);
    }

    @Override
    public void putByte(byte value) {
        this.buffer.put(value);
    }

    @Override
    public void putInt(int value) {
        this.buffer.putInt(value);
    }

    @Override
    public void putLong(long value) {
        this.buffer.putLong(value);
    }

    @Override
    public void putDouble(double value) {
        this.buffer.putDouble(value);
    }

    @Override
    public void putBytes(byte[] value) {
        this.buffer.put(value);
    }

    @Override
    public void putString(String value) {
        int stringId = this.stringRegistry.getId(value);
        this.putInt(stringId);
    }

    @Override
    public void putChar(char value) {
        this.buffer.putChar(value);
    }

    @Override
    public void putShort(short value) {
        this.buffer.putShort(value);
    }

    @Override
    public void putFloat(float value) {
        this.buffer.putFloat(value);
    }

    @Override
    public <T extends Enum<T>> void putEnumeration(T value) {
        this.buffer.putInt(value.ordinal());
    }
}

