/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Iterator;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.io.AbstractValueDeserializer;
import kieker.common.record.io.IValueDeserializer;

public class JsonArrayValueDeserializer
extends AbstractValueDeserializer
implements IValueDeserializer {
    private final Iterator<JsonNode> values;

    protected JsonArrayValueDeserializer(ArrayNode array) {
        this.values = array.iterator();
    }

    public static JsonArrayValueDeserializer create(ArrayNode array) {
        return new JsonArrayValueDeserializer(array);
    }

    @Override
    public boolean getBoolean() {
        return this.values.next().asBoolean();
    }

    @Override
    public byte getByte() throws NumberFormatException {
        return (byte)this.values.next().asInt();
    }

    @Override
    public char getChar() {
        return this.values.next().asText().charAt(0);
    }

    @Override
    public short getShort() throws NumberFormatException {
        return (short)this.values.next().asInt();
    }

    @Override
    public int getInt() throws NumberFormatException {
        return this.values.next().asInt();
    }

    @Override
    public long getLong() throws NumberFormatException {
        return this.values.next().asLong();
    }

    @Override
    public float getFloat() throws NumberFormatException {
        return (float)this.values.next().asDouble();
    }

    @Override
    public double getDouble() throws NumberFormatException {
        return this.values.next().asDouble();
    }

    @Override
    public String getString() {
        return this.values.next().asText();
    }

    @Override
    public <T extends Enum<T>> T getEnumeration(Class<T> clazz) throws RecordInstantiationException {
        int value = this.values.next().asInt();
        return this.enumerationValueOf(clazz, value);
    }
}

