/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.util.dataformat;

import java.nio.ByteBuffer;

public final class VariableLengthEncoding {
    private VariableLengthEncoding() {
    }

    public static void encodeInt(int value, ByteBuffer buffer) {
        byte currentByte;
        int remainingData = value;
        while (true) {
            currentByte = (byte)(remainingData & 0x7F);
            if ((remainingData >>>= 7) == 0) break;
            currentByte = (byte)(currentByte | 0xFFFFFF80);
            buffer.put(currentByte);
        }
        buffer.put(currentByte);
    }

    public static int decodeInt(ByteBuffer buffer) {
        int startPosition = buffer.position();
        int value = 0;
        int shiftAmount = 0;
        while (true) {
            byte currentByte;
            boolean terminalByte;
            boolean bl = terminalByte = (currentByte = buffer.get()) >= 0;
            if (terminalByte) {
                value |= currentByte << shiftAmount;
                break;
            }
            value |= (currentByte & 0x7F) << shiftAmount;
            shiftAmount += 7;
        }
        if (shiftAmount > 28) {
            throw new IllegalArgumentException("Unterminated variable-length int found at position " + startPosition);
        }
        return value;
    }
}

