/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.cxf;

import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.IMonitoringProbe;
import kieker.monitoring.probe.cxf.SOAPHeaderConstants;
import kieker.monitoring.probe.cxf.SOAPTraceRegistry;
import kieker.monitoring.timer.ITimeSource;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapHeaderOutFilterInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OperationExecutionSOAPResponseOutInterceptor
extends SoapHeaderOutFilterInterceptor
implements IMonitoringProbe {
    public static final String SIGNATURE = "public void " + OperationExecutionSOAPResponseOutInterceptor.class.getName() + ".handleMessage(org.apache.cxf.binding.soap.SoapMessage)";
    protected static final ControlFlowRegistry CF_REGISTRY = ControlFlowRegistry.INSTANCE;
    protected static final SessionRegistry SESSION_REGISTRY = SessionRegistry.INSTANCE;
    protected static final SOAPTraceRegistry SOAP_REGISTRY = SOAPTraceRegistry.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationExecutionSOAPResponseOutInterceptor.class);
    protected final IMonitoringController monitoringController;
    protected final ITimeSource timeSource;
    protected final String vmName;

    public OperationExecutionSOAPResponseOutInterceptor() {
        this(MonitoringController.getInstance());
    }

    public OperationExecutionSOAPResponseOutInterceptor(IMonitoringController monitoringCtrl) {
        this.monitoringController = monitoringCtrl;
        this.timeSource = this.monitoringController.getTimeSource();
        this.vmName = this.monitoringController.getHostname();
    }

    public void handleMessage(SoapMessage msg) throws Fault {
        if (!this.monitoringController.isMonitoringEnabled()) {
            return;
        }
        if (!this.monitoringController.isProbeActivated(SIGNATURE)) {
            return;
        }
        long traceId = CF_REGISTRY.recallThreadLocalTraceId();
        boolean isEntryCall = true;
        int eoi = -1;
        int myEoi = -1;
        int myEss = -1;
        if (traceId == -1L) {
            LOGGER.warn("Kieker traceId not registered. Will unset all threadLocal variables and return.");
            this.unsetKiekerThreadLocalData();
            return;
        }
        eoi = CF_REGISTRY.recallThreadLocalEOI();
        String sessionID = SESSION_REGISTRY.recallThreadLocalSessionId();
        myEoi = SOAP_REGISTRY.recallThreadLocalInRequestEOI();
        myEss = SOAP_REGISTRY.recallThreadLocalInRequestESS();
        long tin = SOAP_REGISTRY.recallThreadLocalInRequestTin();
        long tout = this.timeSource.getTime();
        isEntryCall = SOAP_REGISTRY.recallThreadLocalInRequestIsEntryCall();
        this.unsetKiekerThreadLocalData();
        OperationExecutionRecord rec = new OperationExecutionRecord(SIGNATURE, sessionID, traceId, tin, tout, this.vmName, myEoi, myEss);
        this.monitoringController.newMonitoringRecord(rec);
        if (isEntryCall) {
            return;
        }
        Document d = DOMUtils.createDocument();
        Element e = d.createElementNS("http://kieker-monitoring.net", "traceId");
        e.setTextContent(Long.toString(traceId));
        Header hdr = new Header(SOAPHeaderConstants.TRACE_IDENTIFIER_QNAME, (Object)e);
        msg.getHeaders().add(hdr);
        e = d.createElementNS("http://kieker-monitoring.net", "eoi");
        e.setTextContent(Integer.toString(eoi));
        hdr = new Header(SOAPHeaderConstants.EOI_IDENTIFIER_QNAME, (Object)e);
        msg.getHeaders().add(hdr);
    }

    private final void unsetKiekerThreadLocalData() {
        CF_REGISTRY.unsetThreadLocalTraceId();
        CF_REGISTRY.unsetThreadLocalEOI();
        CF_REGISTRY.unsetThreadLocalESS();
        SESSION_REGISTRY.unsetThreadLocalSessionId();
        SOAP_REGISTRY.unsetThreadLocalInRequestIsEntryCall();
        SOAP_REGISTRY.unsetThreadLocalInRequestTin();
        SOAP_REGISTRY.unsetThreadLocalInRequestEOI();
        SOAP_REGISTRY.unsetThreadLocalInRequestESS();
    }
}

