/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.disl.flow.operationExecution;

import ch.usi.dag.disl.annotation.AfterReturning;
import ch.usi.dag.disl.annotation.AfterThrowing;
import ch.usi.dag.disl.annotation.Before;
import ch.usi.dag.disl.annotation.SyntheticLocal;
import ch.usi.dag.disl.dynamiccontext.DynamicContext;
import ch.usi.dag.disl.marker.BodyMarker;
import ch.usi.dag.disl.staticcontext.MethodStaticContext;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.TraceRegistry;
import kieker.monitoring.timer.ITimeSource;

public class FullInstrumentation {
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final TraceRegistry TRACEREGISTRY = TraceRegistry.INSTANCE;
    @SyntheticLocal
    private static boolean newTrace;
    @SyntheticLocal
    private static long traceId;
    @SyntheticLocal
    private static String signature;
    @SyntheticLocal
    private static String clazz;
    @SyntheticLocal
    private static TraceMetadata trace;

    @Before(marker=BodyMarker.class, scope="")
    public static void onMethodEntry(MethodStaticContext msc, DynamicContext dc) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        signature = msc.thisMethodFullName();
        if (!CTRLINST.isProbeActivated(signature)) {
            return;
        }
        trace = TRACEREGISTRY.getTrace();
        boolean bl = newTrace = trace == null;
        if (newTrace) {
            trace = TRACEREGISTRY.registerTrace();
            CTRLINST.newMonitoringRecord(trace);
        }
        traceId = trace.getTraceId();
        clazz = dc.getThis().getClass().toString();
        CTRLINST.newMonitoringRecord(new BeforeOperationEvent(TIME.getTime(), traceId, trace.getNextOrderId(), signature, clazz));
    }

    @AfterReturning(marker=BodyMarker.class, scope="")
    public static void onMethodExit(MethodStaticContext msc) {
        if (!CTRLINST.isMonitoringEnabled() || !CTRLINST.isProbeActivated(signature)) {
            return;
        }
        if (newTrace) {
            TRACEREGISTRY.unregisterTrace();
        }
        CTRLINST.newMonitoringRecord(new AfterOperationEvent(TIME.getTime(), traceId, trace.getNextOrderId(), signature, clazz));
    }

    @AfterThrowing(marker=BodyMarker.class, scope="")
    public static void onMethodException(MethodStaticContext msc, DynamicContext dc) {
        if (!CTRLINST.isMonitoringEnabled() || !CTRLINST.isProbeActivated(signature)) {
            return;
        }
        if (newTrace) {
            TRACEREGISTRY.unregisterTrace();
        }
        CTRLINST.newMonitoringRecord(new AfterOperationFailedEvent(TIME.getTime(), traceId, trace.getNextOrderId(), signature, clazz, dc.getException().toString()));
    }
}

