/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.manual;

import kieker.common.record.controlflow.BranchingRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.probe.IMonitoringProbe;
import kieker.monitoring.timer.ITimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BranchingProbe
implements IMonitoringProbe {
    private static final Logger LOGGER = LoggerFactory.getLogger(BranchingProbe.class);
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIMESOURCE = CTRLINST.getTimeSource();

    private BranchingProbe() {
    }

    public static void monitorBranch(int branchID, int branchingOutcome) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        try {
            CTRLINST.newMonitoringRecord(new BranchingRecord(TIMESOURCE.getTime(), branchID, branchingOutcome));
        }
        catch (Exception ex) {
            LOGGER.error("Error monitoring branching", (Throwable)ex);
        }
    }
}

