/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.queue;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import kieker.monitoring.queue.putstrategy.PutStrategy;
import kieker.monitoring.queue.takestrategy.TakeStrategy;

public class BlockingQueueDecorator<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final Queue<E> q;
    private final PutStrategy putStrategy;
    private final TakeStrategy takeStrategy;

    public BlockingQueueDecorator(Queue<E> q, PutStrategy putStrategy, TakeStrategy takeStrategy) {
        this.q = q;
        this.putStrategy = putStrategy;
        this.takeStrategy = takeStrategy;
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.putStrategy.backoffOffer(this, e);
    }

    @Override
    public boolean offer(E e) {
        boolean offered = this.q.offer(e);
        if (offered) {
            this.takeStrategy.signal();
        }
        return offered;
    }

    @Override
    public E take() throws InterruptedException {
        return this.takeStrategy.waitPoll(this);
    }

    @Override
    public E poll() {
        E e = this.q.poll();
        if (e != null) {
            this.putStrategy.signal();
        }
        return e;
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remainingCapacity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        int count = 0;
        E e = this.poll();
        while (e != null) {
            c.add(e);
            ++count;
            e = this.poll();
        }
        return count;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int count;
        E e = this.poll();
        for (count = 0; e != null && count < maxElements; ++count) {
            c.add(e);
            e = this.poll();
        }
        return count;
    }

    @Override
    public E peek() {
        return this.q.peek();
    }

    @Override
    public Iterator<E> iterator() {
        return this.q.iterator();
    }

    @Override
    public int size() {
        return this.q.size();
    }

    @Override
    public String toString() {
        return this.q.toString();
    }
}

