/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Path;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.io.IValueSerializer;
import kieker.common.registry.writer.WriterRegistry;
import kieker.monitoring.writer.compression.ICompressionFilter;

public abstract class AbstractLogStreamHandler {
    protected final boolean flushLogFile;
    protected final ICompressionFilter compressionFilter;
    protected int numOfEntries;
    protected final WriterRegistry writerRegistry;
    protected final Charset charset;
    protected IValueSerializer serializer;
    protected OutputStream serializedStream;
    protected WritableByteChannel outputChannel;
    protected int numOfBytes;
    protected String extension;

    public AbstractLogStreamHandler(Boolean flushLogFile, Integer bufferSize, Charset charset, ICompressionFilter compressionFilter, WriterRegistry writerRegistry) {
        this.flushLogFile = flushLogFile;
        this.compressionFilter = compressionFilter;
        this.charset = charset;
        this.writerRegistry = writerRegistry;
    }

    public void initialize(OutputStream serializedOutputStream, Path fileName) throws IOException {
        this.serializedStream = serializedOutputStream;
        this.outputChannel = Channels.newChannel(this.compressionFilter.chainOutputStream(serializedOutputStream, fileName));
        this.numOfEntries = 0;
    }

    public int getNumOfEntries() {
        return this.numOfEntries;
    }

    public long getNumOfBytes() {
        return this.numOfBytes;
    }

    public void close() throws IOException {
        this.outputChannel.close();
        this.serializedStream.close();
    }

    public String getFileExtension() {
        String compressExtension = this.compressionFilter.getExtension();
        if (compressExtension == null) {
            return this.extension;
        }
        return compressExtension;
    }

    public abstract void serialize(IMonitoringRecord var1, int var2) throws IOException;
}

