/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.io.BinaryValueSerializer;
import kieker.common.registry.writer.WriterRegistry;
import kieker.monitoring.writer.WriterUtil;
import kieker.monitoring.writer.compression.ICompressionFilter;
import kieker.monitoring.writer.filesystem.AbstractLogStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryLogStreamHandler
extends AbstractLogStreamHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryLogStreamHandler.class);
    private final ByteBuffer buffer;

    public BinaryLogStreamHandler(Boolean flushLogFile, Integer bufferSize, Charset charset, ICompressionFilter compressionFilter, WriterRegistry writerRegistry) {
        super(flushLogFile, bufferSize, charset, compressionFilter, writerRegistry);
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        this.serializer = BinaryValueSerializer.create(this.buffer, writerRegistry);
        this.extension = ".bin";
    }

    @Override
    public void serialize(IMonitoringRecord record, int id) throws IOException {
        this.requestBufferSpace(12 + record.getSize());
        this.buffer.putInt(id);
        this.buffer.putLong(record.getLoggingTimestamp());
        record.serialize(this.serializer);
        ++this.numOfEntries;
    }

    @Override
    public void close() throws IOException {
        this.buffer.flip();
        try {
            while (this.buffer.hasRemaining()) {
                this.numOfBytes += this.outputChannel.write(this.buffer);
            }
            this.buffer.clear();
        }
        catch (IOException e) {
            LOGGER.error("Caught exception while writing to the channel.", (Throwable)e);
            WriterUtil.close(this.outputChannel, LOGGER);
        }
        this.serializedStream.flush();
        super.close();
    }

    private void requestBufferSpace(int bufferSpace) throws IOException {
        if (bufferSpace > this.buffer.remaining()) {
            this.buffer.flip();
            try {
                while (this.buffer.hasRemaining()) {
                    this.numOfBytes += this.outputChannel.write(this.buffer);
                }
                this.buffer.clear();
            }
            catch (IOException e) {
                LOGGER.error("Caught exception while writing to the channel.", (Throwable)e);
                WriterUtil.close(this.outputChannel, LOGGER);
            }
            if (this.flushLogFile) {
                this.serializedStream.flush();
            }
        }
    }
}

