/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools;

import kieker.tools.util.CLIHelpFormatter;
import kieker.tools.util.ToolsUtil;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractCommandLineTool {
    public static final String CMD_OPT_NAME_HELP_LONG = "help";
    public static final String CMD_OPT_NAME_HELP_SHORT = "h";
    public static final String CMD_OPT_NAME_VERBOSE_LONG = "verbose";
    public static final String CMD_OPT_NAME_VERBOSE_SHORT = "v";
    public static final String CMD_OPT_NAME_DEBUG_LONG = "debug";
    public static final String CMD_OPT_NAME_DEBUG_SHORT = "d";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCommandLineTool.class);
    private final boolean useSystemExit;

    public AbstractCommandLineTool(boolean useSystemExit) {
        this.useSystemExit = useSystemExit;
    }

    public final void start(String[] args) {
        boolean success;
        Options options = new Options();
        this.addDefaultOptions(options);
        this.addAdditionalOptions(options);
        CommandLine commandLine = this.parseCommandLineArguments(options, args);
        if (null != commandLine) {
            this.initializeLogger(commandLine);
            if (commandLine.hasOption(CMD_OPT_NAME_HELP_SHORT)) {
                this.printUsage(options);
                System.exit(0);
            }
            if (!(success = this.readPropertiesFromCommandLine(commandLine))) {
                LOGGER.info("Use the option `--{}` for usage information", (Object)CMD_OPT_NAME_HELP_LONG);
            } else {
                success = this.performTask();
            }
        } else {
            success = false;
        }
        LOGGER.info("See 'kieker.log' for details");
        if (!success && this.useSystemExit) {
            System.exit(1);
        }
    }

    private void initializeLogger(CommandLine commandLine) {
        if (commandLine.hasOption('d')) {
            ToolsUtil.loadDebugLogger();
        } else if (commandLine.hasOption('v')) {
            ToolsUtil.loadVerboseLogger();
        } else {
            ToolsUtil.loadDefaultLogger();
        }
    }

    private void printUsage(Options options) {
        HelpFormatter formatter = this.getHelpFormatter();
        formatter.printHelp(this.getClass().getName(), options, true);
    }

    private void addDefaultOptions(Options options) {
        options.addOption(new Option(CMD_OPT_NAME_VERBOSE_SHORT, CMD_OPT_NAME_VERBOSE_LONG, false, "verbosely prints additional information"));
        options.addOption(new Option(CMD_OPT_NAME_DEBUG_SHORT, CMD_OPT_NAME_DEBUG_LONG, false, "prints additional debug information"));
        options.addOption(new Option(CMD_OPT_NAME_HELP_SHORT, CMD_OPT_NAME_HELP_LONG, false, "prints the usage information for the tool, including available options"));
    }

    private CommandLine parseCommandLineArguments(Options options, String[] arguments) {
        BasicParser parser = new BasicParser();
        try {
            return parser.parse(options, arguments);
        }
        catch (ParseException ex) {
            LOGGER.error("An error occurred while parsing the command line arguments: {}", (Object)ex.getMessage(), (Object)ex);
            LOGGER.info("Use the option `--{}` for usage information", (Object)CMD_OPT_NAME_HELP_LONG);
            return null;
        }
    }

    protected abstract void addAdditionalOptions(Options var1);

    protected abstract boolean readPropertiesFromCommandLine(CommandLine var1);

    protected abstract boolean performTask();

    protected HelpFormatter getHelpFormatter() {
        return new CLIHelpFormatter();
    }
}

