/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.common;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import kieker.common.configuration.Configuration;
import kieker.common.exception.ConfigurationException;
import kieker.monitoring.core.configuration.ConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLegacyTool<T> {
    public static final int SUCCESS_EXIT_CODE = 0;
    public static final int RUNTIME_ERROR = 1;
    public static final int CONFIGURATION_ERROR = 2;
    public static final int PARAMETER_ERROR = 3;
    public static final int USAGE_EXIT_CODE = 4;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getCanonicalName());
    protected boolean help = false;
    protected T parameterConfiguration;
    protected Configuration kiekerConfiguration;

    public int run(String title, String label, String[] args, T configuration) {
        this.parameterConfiguration = configuration;
        this.logger.debug(title);
        JCommander commander = new JCommander(configuration);
        try {
            commander.parse(args);
            if (this.checkParameters(commander)) {
                if (this.help) {
                    commander.usage();
                    return 4;
                }
                this.kiekerConfiguration = this.readConfiguration();
                if (this.checkConfiguration(this.kiekerConfiguration, commander)) {
                    return this.execute(commander, label);
                }
                return 2;
            }
            this.logger.error("Configuration Error");
            return 2;
        }
        catch (ParameterException e) {
            this.logger.error(e.getLocalizedMessage());
            commander.usage();
            return 3;
        }
        catch (ConfigurationException e) {
            this.logger.error(e.getLocalizedMessage());
            commander.usage();
            return 2;
        }
    }

    protected abstract int execute(JCommander var1, String var2) throws ConfigurationException;

    protected Configuration readConfiguration() {
        if (this.getConfigurationFile() != null) {
            return ConfigurationFactory.createConfigurationFromFile(this.getConfigurationFile().getAbsolutePath());
        }
        return null;
    }

    protected abstract File getConfigurationFile();

    protected abstract boolean checkConfiguration(Configuration var1, JCommander var2);

    protected abstract boolean checkParameters(JCommander var1) throws ConfigurationException;

    protected abstract void shutdownService();
}

