/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.source;

import kieker.analysis.source.IAccessHandler;
import kieker.analysis.source.ISourceCompositeStage;
import kieker.analysis.source.rest.RestServiceStage;
import kieker.common.configuration.Configuration;
import kieker.common.exception.ConfigurationException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.classpath.InstantiationFactory;
import teetime.framework.CompositeStage;
import teetime.framework.OutputPort;

public class RestServiceCompositeStage
extends CompositeStage
implements ISourceCompositeStage {
    private static final String PREFIX = RestServiceCompositeStage.class.getCanonicalName();
    private static final String SERVICE_HOSTNAME = PREFIX + ".hostname";
    private static final String SERVICE_PORT = PREFIX + ".port";
    private static final String ACCESS_HANDLER = PREFIX + ".accessHandler";
    private final RestServiceStage serviceStage;

    public RestServiceCompositeStage(Configuration configuration) throws ConfigurationException {
        String hostname = configuration.getStringProperty(SERVICE_HOSTNAME);
        int port = configuration.getIntProperty(SERVICE_PORT);
        IAccessHandler accessRestrictionHandler = InstantiationFactory.createWithConfiguration(IAccessHandler.class, configuration.getStringProperty(ACCESS_HANDLER), configuration);
        this.serviceStage = new RestServiceStage(hostname, port, accessRestrictionHandler);
    }

    public RestServiceCompositeStage(String hostname, int port, IAccessHandler accessHandler) {
        this.serviceStage = new RestServiceStage(hostname, port, accessHandler);
    }

    @Override
    public OutputPort<IMonitoringRecord> getOutputPort() {
        return this.serviceStage.getOutputPort();
    }
}

