/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.call.tree;

import kieker.model.repository.AssemblyComponentOperationPairFactory;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AssemblyComponent;
import kieker.model.system.model.Execution;
import kieker.model.system.model.Operation;
import kieker.model.system.model.SynchronousCallMessage;
import kieker.model.system.model.util.AssemblyComponentOperationPair;
import kieker.tools.trace.analysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.trace.analysis.filter.visualization.graph.NoOriginRetentionPolicy;
import kieker.visualization.trace.call.tree.AbstractAggregatedCallTreeFilter;
import kieker.visualization.trace.call.tree.AggregatedAssemblyComponentOperationCallTreeNode;

public class AggregatedAssemblyComponentOperationCallTreeFilter
extends AbstractAggregatedCallTreeFilter<AssemblyComponentOperationPair> {
    public AggregatedAssemblyComponentOperationCallTreeFilter(SystemModelRepository repository, boolean includeWeights, boolean shortLabels, String dotOutputFile) {
        super(repository, includeWeights, shortLabels, dotOutputFile);
        AggregatedAssemblyComponentOperationCallTreeNode root = new AggregatedAssemblyComponentOperationCallTreeNode(0, AssemblyComponentOperationPairFactory.ROOT_PAIR, true, null, (IOriginRetentionPolicy)NoOriginRetentionPolicy.createInstance());
        this.setRoot(root);
    }

    @Override
    protected AssemblyComponentOperationPair concreteCreatePair(SynchronousCallMessage callMsg) {
        Execution execution = callMsg.getReceivingExecution();
        AssemblyComponent assemblyComponent = execution.getAllocationComponent().getAssemblyComponent();
        Operation op = execution.getOperation();
        return this.getSystemModelRepository().getAssemblyPairFactory().getPairInstanceByPair(assemblyComponent, op);
    }
}

