/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.dependency.graph;

import java.util.concurrent.TimeUnit;
import kieker.model.repository.AllocationRepository;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AbstractMessage;
import kieker.model.system.model.AllocationComponent;
import kieker.model.system.model.MessageTrace;
import kieker.model.system.model.SynchronousReplyMessage;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraph;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraphFilter;
import kieker.visualization.trace.dependency.graph.ComponentAllocationDependencyGraph;
import kieker.visualization.trace.dependency.graph.DependencyGraphNode;

public class ComponentDependencyGraphAllocationFilter
extends AbstractDependencyGraphFilter<AllocationComponent> {
    public ComponentDependencyGraphAllocationFilter(SystemModelRepository repository, TimeUnit timeUnit) {
        super(repository, timeUnit, new ComponentAllocationDependencyGraph(AllocationRepository.ROOT_ALLOCATION_COMPONENT));
    }

    @Override
    protected void execute(MessageTrace t) throws Exception {
        for (AbstractMessage m : t.getSequenceAsVector()) {
            if (m instanceof SynchronousReplyMessage) continue;
            AllocationComponent senderComponent = m.getSendingExecution().getAllocationComponent();
            AllocationComponent receiverComponent = m.getReceivingExecution().getAllocationComponent();
            DependencyGraphNode<Object> senderNode = ((AbstractDependencyGraph)this.getGraph()).getNode(senderComponent.getId());
            DependencyGraphNode<Object> receiverNode = ((AbstractDependencyGraph)this.getGraph()).getNode(receiverComponent.getId());
            if (senderNode == null) {
                senderNode = new DependencyGraphNode<AllocationComponent>(senderComponent.getId(), senderComponent, t.getTraceInformation(), this.getOriginRetentionPolicy());
                if (m.getSendingExecution().isAssumed()) {
                    senderNode.setAssumed();
                }
                ((AbstractDependencyGraph)this.getGraph()).addNode(senderNode.getId(), senderNode);
            } else {
                this.handleOrigin(senderNode, t.getTraceInformation());
            }
            if (receiverNode == null) {
                receiverNode = new DependencyGraphNode<AllocationComponent>(receiverComponent.getId(), receiverComponent, t.getTraceInformation(), this.getOriginRetentionPolicy());
                if (m.getReceivingExecution().isAssumed()) {
                    receiverNode.setAssumed();
                }
                ((AbstractDependencyGraph)this.getGraph()).addNode(receiverNode.getId(), receiverNode);
            } else {
                this.handleOrigin(receiverNode, t.getTraceInformation());
            }
            boolean assumed = this.isDependencyAssumed(senderNode, receiverNode);
            senderNode.addOutgoingDependency(receiverNode, assumed, t.getTraceInformation(), this.getOriginRetentionPolicy());
            receiverNode.addIncomingDependency(senderNode, assumed, t.getTraceInformation(), this.getOriginRetentionPolicy());
            this.invokeDecorators(m, senderNode, receiverNode);
        }
        this.reportSuccess(t.getTraceId());
    }

    protected void onTerminating() {
        this.getOutputPort().send(this.getGraph());
        super.onTerminating();
    }
}

