/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IAnalysisController;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.model.analysisMetaModel.MIDependency;
import kieker.analysis.model.analysisMetaModel.MIPlugin;
import kieker.analysis.model.analysisMetaModel.MIProject;
import kieker.analysis.model.analysisMetaModel.MIRepository;
import kieker.analysis.plugin.AbstractPlugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.analysis.plugin.reader.IReaderPlugin;
import kieker.analysis.repository.AbstractRepository;
import kieker.analysis.stage.model.MetaModelHandler;
import kieker.common.configuration.Configuration;
import kieker.common.record.misc.KiekerMetadataRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@kieker.analysis.annotation.AnalysisController(configuration={@Property(name="recordsTimeUnit", defaultValue="NANOSECONDS"), @Property(name="projectName", defaultValue="AnalysisProject")})
public final class AnalysisController
implements IAnalysisController {
    static final Logger LOG = LoggerFactory.getLogger(AnalysisController.class);
    private final String projectName;
    private final Collection<MIDependency> dependencies = new CopyOnWriteArrayList<MIDependency>();
    private final Collection<AbstractReaderPlugin> readers = new CopyOnWriteArrayList<AbstractReaderPlugin>();
    private final Collection<AbstractFilterPlugin> filters = new CopyOnWriteArrayList<AbstractFilterPlugin>();
    private final Collection<AbstractRepository> repos = new CopyOnWriteArrayList<AbstractRepository>();
    private final Collection<IStateObserver> stateObservers = new CopyOnWriteArrayList<IStateObserver>();
    private final CountDownLatch initializationLatch = new CountDownLatch(1);
    private final Set<String> registeredComponentNames = new CopyOnWriteArraySet<String>();
    private Map<MIPlugin, AbstractPlugin> pluginModelMap;
    private Map<MIRepository, AbstractRepository> repositoryModelMap;
    private volatile STATE state = STATE.READY;
    private final Configuration globalConfiguration;

    public AnalysisController() {
        this(new Configuration());
    }

    public AnalysisController(String projectName) {
        this(AnalysisController.createConfigurationWithProjectName(projectName));
    }

    public AnalysisController(File file) throws IOException, AnalysisConfigurationException {
        this(file, AnalysisController.class.getClassLoader());
    }

    public AnalysisController(File file, ClassLoader classLoader) throws IOException, AnalysisConfigurationException {
        this(AnalysisController.loadFromFile(file), classLoader);
    }

    public AnalysisController(MIProject project) throws AnalysisConfigurationException {
        this(project, AnalysisController.class.getClassLoader());
    }

    public AnalysisController(MIProject project, ClassLoader classLoader) throws AnalysisConfigurationException {
        if (project == null) {
            throw new NullPointerException("Can not load project null.");
        }
        this.globalConfiguration = this.validateConfiguration(new Configuration(this.getDefaultConfiguration()));
        this.loadFromModelProject(project, classLoader);
        this.projectName = project.getName();
    }

    public AnalysisController(Configuration configuration) {
        this.globalConfiguration = this.validateConfiguration(configuration.flatten(this.getDefaultConfiguration()));
        this.projectName = this.getProperty("projectName");
    }

    private Configuration validateConfiguration(Configuration configuration) {
        String stringProperty = configuration.getStringProperty("recordsTimeUnit");
        try {
            TimeUnit.valueOf(stringProperty);
        }
        catch (IllegalArgumentException ignore) {
            LOG.warn("{} is no valid TimeUnit! Using NANOSECONDS instead.", (Object)stringProperty);
            configuration.setProperty("recordsTimeUnit", TimeUnit.NANOSECONDS.name());
        }
        return configuration;
    }

    private static final Configuration createConfigurationWithProjectName(String projectName) {
        Configuration configuration = new Configuration();
        configuration.setProperty("projectName", projectName);
        return configuration;
    }

    private final Configuration getDefaultConfiguration() {
        Configuration defaultConfiguration = new Configuration();
        kieker.analysis.annotation.AnalysisController annotation = this.getClass().getAnnotation(kieker.analysis.annotation.AnalysisController.class);
        if (null != annotation) {
            for (Property property : annotation.configuration()) {
                defaultConfiguration.setProperty(property.name(), property.defaultValue());
            }
        }
        return defaultConfiguration;
    }

    public final void handleKiekerMetadataRecord(KiekerMetadataRecord record) {
        LOG.info("Kieker metadata: version='{}', controllerName='{}', hostname='{}', experimentId='{}', debugMode='{}', timeOffset='{}', timeUnit='{}', numberOfRecords='{}'", record.getVersion(), record.getControllerName(), record.getHostname(), record.getExperimentId(), record.isDebugMode(), record.getTimeOffset(), record.getTimeUnit(), record.getNumberOfRecords());
    }

    @Override
    public final void registerStateObserver(IStateObserver stateObserver) {
        this.stateObservers.add(stateObserver);
    }

    @Override
    public final void unregisterStateObserver(IStateObserver stateObserver) {
        this.stateObservers.remove(stateObserver);
    }

    private final void notifyStateObservers() {
        STATE currState = this.state;
        for (IStateObserver observer : this.stateObservers) {
            observer.update(this, currState);
        }
    }

    @Override
    public final String getProperty(String key) {
        return this.globalConfiguration.getStringProperty(key);
    }

    private final void loadFromModelProject(MIProject mProject, ClassLoader classLoader) throws AnalysisConfigurationException {
        HashMap<MIRepository, AbstractRepository> repositoryMap = new HashMap<MIRepository, AbstractRepository>();
        HashMap<MIPlugin, AbstractPlugin> pluginMap = new HashMap<MIPlugin, AbstractPlugin>();
        ArrayList<MetaModelHandler.PluginConnection> pluginConnections = new ArrayList<MetaModelHandler.PluginConnection>();
        ArrayList<MetaModelHandler.RepositoryConnection> repositoryConnections = new ArrayList<MetaModelHandler.RepositoryConnection>();
        MetaModelHandler.metaModelToJava(mProject, this, pluginConnections, repositoryConnections, this.dependencies, classLoader, this.globalConfiguration, repositoryMap, pluginMap);
        for (MetaModelHandler.PluginConnection pluginConnection : pluginConnections) {
            this.connect(pluginConnection.getSource(), pluginConnection.getOutputName(), pluginConnection.getDestination(), pluginConnection.getInputName());
        }
        for (MetaModelHandler.RepositoryConnection repositoryConnection : repositoryConnections) {
            this.connect(repositoryConnection.getSource(), repositoryConnection.getOutputName(), repositoryConnection.getRepository());
        }
        this.pluginModelMap = pluginMap;
        this.repositoryModelMap = repositoryMap;
    }

    @Override
    public final void saveToFile(File file) throws IOException, AnalysisConfigurationException {
        MIProject mProject = this.getCurrentConfiguration();
        AnalysisController.saveToFile(file, mProject);
    }

    @Override
    public final void saveToFile(String pathname) throws IOException, AnalysisConfigurationException {
        this.saveToFile(new File(pathname));
    }

    @Override
    public final void connect(AbstractPlugin src, String outputPortName, AbstractPlugin dst, String inputPortName) throws AnalysisConfigurationException {
        if (this.state != STATE.READY) {
            throw new IllegalStateException("Unable to connect readers and filters after starting analysis.");
        }
        if (src == null || dst == null || inputPortName == null || outputPortName == null) {
            throw new AnalysisConfigurationException("Unable to connect null values.");
        }
        if (dst instanceof IReaderPlugin) {
            throw new AnalysisConfigurationException("The plugin '" + dst.getName() + "' (" + dst.getPluginName() + ") is a reader and can not be connected to.");
        }
        if (!this.filters.contains(src) && !this.readers.contains(src)) {
            throw new AnalysisConfigurationException("The plugin '" + src.getName() + "' (" + src.getPluginName() + ") is not registered.");
        }
        if (!this.filters.contains(dst)) {
            throw new AnalysisConfigurationException("The plugin '" + dst.getName() + "' (" + dst.getPluginName() + ") is not registered.");
        }
        AbstractPlugin.connect(src, outputPortName, dst, inputPortName);
    }

    @Override
    public final void connect(AbstractPlugin plugin, String repositoryPort, AbstractRepository repository) throws AnalysisConfigurationException {
        if (this.state != STATE.READY) {
            throw new IllegalStateException("Unable to connect repositories after starting analysis.");
        }
        if (repository == null) {
            throw new AnalysisConfigurationException("Plugin '" + plugin.getName() + "' (" + plugin.getPluginName() + ") has unconnected repositories.");
        }
        if (!this.filters.contains(plugin) && !this.readers.contains(plugin)) {
            throw new AnalysisConfigurationException("The plugin '" + plugin.getName() + "' (" + plugin.getPluginName() + ") is not registered.");
        }
        if (!this.repos.contains(repository)) {
            throw new AnalysisConfigurationException("The repository '" + repository.getName() + "' (" + repository.getRepositoryName() + ") is not registered.");
        }
        plugin.connect(repositoryPort, repository);
    }

    @Override
    public final MIProject getCurrentConfiguration() throws AnalysisConfigurationException {
        return MetaModelHandler.javaToMetaModel(this.readers, this.filters, this.repos, this.dependencies, this.projectName, this.globalConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() throws AnalysisConfigurationException {
        try {
            Iterator<AbstractFilterPlugin> iterator = this;
            synchronized (iterator) {
                if (this.state != STATE.READY) {
                    throw new IllegalStateException("AnalysisController may be executed only once.");
                }
                this.state = STATE.RUNNING;
                this.notifyStateObservers();
            }
            if (this.readers.size() == 0) {
                this.terminate(true);
                throw new AnalysisConfigurationException("No log reader registered.");
            }
            for (AbstractReaderPlugin abstractReaderPlugin : this.readers) {
                if (!abstractReaderPlugin.areAllRepositoryPortsConnected()) {
                    this.terminate(true);
                    throw new AnalysisConfigurationException("Reader '" + abstractReaderPlugin.getName() + "' (" + abstractReaderPlugin.getPluginName() + ") has unconnected repositories.");
                }
                if (abstractReaderPlugin.start()) continue;
                this.terminate(true);
                throw new AnalysisConfigurationException("Reader '" + abstractReaderPlugin.getName() + "' (" + abstractReaderPlugin.getPluginName() + ") failed to initialize.");
            }
            for (AbstractFilterPlugin abstractFilterPlugin : this.filters) {
                if (!abstractFilterPlugin.areAllRepositoryPortsConnected()) {
                    this.terminate(true);
                    throw new AnalysisConfigurationException("Plugin '" + abstractFilterPlugin.getName() + "' (" + abstractFilterPlugin.getPluginName() + ") has unconnected repositories.");
                }
                if (abstractFilterPlugin.start()) continue;
                this.terminate(true);
                throw new AnalysisConfigurationException("Plugin '" + abstractFilterPlugin.getName() + "' (" + abstractFilterPlugin.getPluginName() + ") failed to initialize.");
            }
            final CountDownLatch readerLatch = new CountDownLatch(this.readers.size());
            for (final AbstractReaderPlugin reader : this.readers) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!reader.read()) {
                                LOG.error("Calling read() on Reader '{}' ({})  returned false.", (Object)reader.getName(), (Object)reader.getPluginName());
                                AnalysisController.this.terminate(true);
                            }
                        }
                        catch (Throwable t) {
                            LOG.error("Exception while reading on Reader '{}' ({}).", reader.getName(), reader.getPluginName(), t);
                            AnalysisController.this.terminate(true);
                        }
                        finally {
                            readerLatch.countDown();
                        }
                    }
                }).start();
            }
            try {
                this.initializationLatch.countDown();
                readerLatch.await();
            }
            catch (InterruptedException interruptedException) {
                LOG.warn("Interrupted while waiting for readers to finish", interruptedException);
            }
        }
        finally {
            this.initializationLatch.countDown();
            this.terminate();
        }
    }

    public final void awaitInitialization() {
        try {
            this.initializationLatch.await();
        }
        catch (InterruptedException ex) {
            LOG.warn("Interrupted while waiting for initialization of analysis controller.", ex);
        }
    }

    @Override
    public final void terminate() {
        this.terminate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void terminate(boolean error) {
        try {
            Iterator<AbstractFilterPlugin> iterator = this;
            synchronized (iterator) {
                block14: {
                    if (this.state == STATE.RUNNING) break block14;
                    return;
                }
                this.state = STATE.TERMINATING;
            }
            if (error) {
                LOG.info("Error during analysis. Terminating ...");
            } else {
                LOG.info("Terminating analysis.");
            }
            for (AbstractReaderPlugin reader : this.readers) {
                reader.shutdown(error);
            }
            for (AbstractFilterPlugin filter : this.filters) {
                filter.shutdown(error);
            }
            this.state = error ? STATE.FAILED : STATE.TERMINATED;
        }
        catch (Throwable t) {
            this.state = STATE.FAILED;
            LOG.error("Error during shutdown.", t);
        }
        finally {
            this.notifyStateObservers();
        }
    }

    public final void registerReader(AbstractReaderPlugin reader) {
        if (this.state != STATE.READY) {
            throw new IllegalStateException("Unable to register filter after starting analysis.");
        }
        if (this.readers.contains(reader)) {
            LOG.warn("Reader {} already registered.", (Object)reader.getName());
            return;
        }
        this.readers.add(reader);
        LOG.debug("Registered reader {}", (Object)reader);
    }

    public final void registerFilter(AbstractFilterPlugin filter) {
        if (this.state != STATE.READY) {
            throw new IllegalStateException("Unable to register filter after starting analysis.");
        }
        if (this.filters.contains(filter)) {
            LOG.warn("Filter '{}' ({}) already registered.", (Object)filter.getName(), (Object)filter.getPluginName());
            return;
        }
        this.filters.add(filter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registered plugin " + filter);
        }
    }

    public final void registerRepository(AbstractRepository repository) {
        if (this.state != STATE.READY) {
            throw new IllegalStateException("Unable to register respository after starting analysis.");
        }
        if (this.repos.contains(repository)) {
            LOG.warn("Repository '{}' ({}) already registered.", (Object)repository.getName(), (Object)repository.getRepositoryName());
            return;
        }
        this.repos.add(repository);
        LOG.debug("Registered repository '{}' ({})", (Object)repository.getName(), (Object)repository.getRepositoryName());
    }

    @Override
    public final String getProjectName() {
        return this.projectName;
    }

    @Override
    public final Collection<AbstractReaderPlugin> getReaders() {
        return Collections.unmodifiableCollection(this.readers);
    }

    @Override
    public final Collection<AbstractFilterPlugin> getFilters() {
        return Collections.unmodifiableCollection(this.filters);
    }

    @Override
    public final Collection<AbstractRepository> getRepositories() {
        return Collections.unmodifiableCollection(this.repos);
    }

    @Override
    public final STATE getState() {
        return this.state;
    }

    public static final MIProject loadFromFile(File file) throws IOException {
        try {
            return MetaModelHandler.loadProjectFromFile(file);
        }
        catch (IOException ex) {
            IOException newEx = new IOException("Error loading file '" + file.getAbsolutePath() + "'.");
            newEx.initCause(ex);
            throw newEx;
        }
        catch (Exception ex) {
            IOException newEx = new IOException("The given file '" + file.getAbsolutePath() + "' is not a valid kax-configuration file.");
            newEx.initCause(ex);
            throw newEx;
        }
    }

    public static final void saveToFile(File file, MIProject project) throws IOException {
        try {
            MetaModelHandler.saveProjectToFile(file, project);
        }
        catch (IOException ex) {
            IOException newEx = new IOException("Unable to save configuration file '" + file.getAbsolutePath() + "'.");
            newEx.initCause(ex);
            throw newEx;
        }
    }

    public static final AnalysisControllerWithMapping createAnalysisController(MIProject project, ClassLoader classLoader) throws AnalysisConfigurationException {
        AnalysisController controller = new AnalysisController(project, classLoader);
        return new AnalysisControllerWithMapping(controller, controller.pluginModelMap, controller.repositoryModelMap);
    }

    public boolean tryRegisterComponentName(String name) {
        return this.registeredComponentNames.add(name);
    }

    public static interface IStateObserver {
        public void update(AnalysisController var1, STATE var2);
    }

    public static enum STATE {
        READY,
        RUNNING,
        TERMINATING,
        TERMINATED,
        FAILED;

    }

    public static final class AnalysisControllerWithMapping {
        private final Map<MIPlugin, AbstractPlugin> pluginMap;
        private final Map<MIRepository, AbstractRepository> repositoryMap;
        private final AnalysisController controller;

        public AnalysisControllerWithMapping(AnalysisController controller, Map<MIPlugin, AbstractPlugin> pluginMap, Map<MIRepository, AbstractRepository> repositoryMap) {
            this.controller = controller;
            this.pluginMap = pluginMap;
            this.repositoryMap = repositoryMap;
        }

        public Map<MIPlugin, AbstractPlugin> getPluginMap() {
            return this.pluginMap;
        }

        public Map<MIRepository, AbstractRepository> getRepositoryMap() {
            return this.repositoryMap;
        }

        public AnalysisController getController() {
            return this.controller;
        }
    }
}

