/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.filesystem;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.analysis.plugin.reader.util.IMonitoringRecordReceiver;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.BinaryValueDeserializer;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BinaryFileStreamProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryFileStreamProcessor.class);
    private static final int LONG_BYTES = 8;
    private final CachedRecordFactoryCatalog recordFactories = CachedRecordFactoryCatalog.getInstance();
    private final ByteBuffer buffer;
    private final ReaderRegistry<String> stringRegistry;
    private final IMonitoringRecordReceiver recordReceiver;

    public BinaryFileStreamProcessor(ReaderRegistry<String> stringRegistry, IMonitoringRecordReceiver recordReceiver) {
        this.stringRegistry = stringRegistry;
        this.buffer = ByteBuffer.allocate(1024000);
        this.recordReceiver = recordReceiver;
    }

    public void createRecordsFromBinaryFile(DataInputStream inputStream) throws IOException, MonitoringRecordException {
        BinaryValueDeserializer deserializer = BinaryValueDeserializer.create(this.buffer, this.stringRegistry);
        boolean endOfStreamReached = false;
        while (!endOfStreamReached) {
            byte[] bytes = this.buffer.array();
            int bytesRead = inputStream.read(bytes, this.buffer.position(), this.buffer.remaining());
            this.buffer.position(this.buffer.position() + bytesRead);
            while (bytesRead > 0) {
                bytes = this.buffer.array();
                bytesRead = inputStream.read(bytes, this.buffer.position(), this.buffer.remaining());
                if (bytesRead < 0) continue;
                this.buffer.position(this.buffer.position() + bytesRead);
            }
            if (bytesRead == -1) {
                endOfStreamReached = true;
            }
            this.processBuffer(deserializer);
            if (!endOfStreamReached) continue;
            inputStream.close();
        }
    }

    private void processBuffer(IValueDeserializer deserializer) throws IOException {
        this.buffer.flip();
        try {
            while (this.buffer.position() + 4 <= this.buffer.limit()) {
                this.buffer.mark();
                IMonitoringRecord record = this.deserializeRecord(deserializer);
                if (record == null) {
                    return;
                }
                this.recordReceiver.newMonitoringRecord(record);
            }
            this.buffer.mark();
            this.buffer.compact();
        }
        catch (BufferUnderflowException ex) {
            LOGGER.warn("Unexpected buffer underflow. Resetting and compacting buffer.", ex);
            this.buffer.reset();
            this.buffer.compact();
            throw ex;
        }
    }

    private IMonitoringRecord deserializeRecord(IValueDeserializer deserializer) throws IOException {
        int clazzId = this.buffer.getInt();
        String recordClassName = this.stringRegistry.get(clazzId);
        if (recordClassName == null) {
            LOGGER.error("Missing classname mapping for record type id '{}'", (Object)clazzId);
            return null;
        }
        if (this.buffer.remaining() < 8) {
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
        long loggingTimestamp = this.buffer.getLong();
        IRecordFactory<? extends IMonitoringRecord> recordFactory = this.recordFactories.get(recordClassName);
        if (this.buffer.remaining() < recordFactory.getRecordSizeInBytes()) {
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
        try {
            IMonitoringRecord record = recordFactory.create(deserializer);
            record.setLoggingTimestamp(loggingTimestamp);
            return record;
        }
        catch (RecordInstantiationException ex) {
            LOGGER.warn("Failed to create: {} error {}", (Object)recordClassName, (Object)ex);
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
        catch (BufferUnderflowException ex) {
            LOGGER.warn("Failed to create: {} error {}", (Object)recordClassName, (Object)ex);
            this.buffer.reset();
            this.buffer.compact();
            return null;
        }
    }
}

