/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.newio.deserializer;

import java.nio.ByteBuffer;
import java.util.List;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.reader.newio.deserializer.AbstractMonitoringRecordDeserializer;
import kieker.analysis.plugin.reader.newio.deserializer.InvalidFormatException;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.dataformat.FormatIdentifier;

public abstract class AbstractContainerFormatDeserializer
extends AbstractMonitoringRecordDeserializer {
    public static final int CONTAINER_IDENTIFIER = FormatIdentifier.CONTAINER_FORMAT.getIdentifierValue();
    private static final int HEADER_SIZE = 8;

    public AbstractContainerFormatDeserializer(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @Override
    public List<IMonitoringRecord> deserializeRecords(ByteBuffer buffer, int dataSize) {
        int magic = buffer.getInt();
        if (magic != CONTAINER_IDENTIFIER) {
            throw new InvalidFormatException(String.format("Invalid magic value %08x was found.", magic));
        }
        int formatIdentifier = buffer.getInt();
        if (formatIdentifier != this.getFormatIdentifier()) {
            throw new InvalidFormatException(String.format("An invalid format identifier %08x was found.", formatIdentifier));
        }
        return this.decodeRecords(buffer, dataSize - 8);
    }

    protected abstract List<IMonitoringRecord> decodeRecords(ByteBuffer var1, int var2) throws InvalidFormatException;

    protected abstract int getFormatIdentifier();
}

