/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import kieker.common.record.misc.RegistryRecord;
import kieker.common.registry.reader.ReaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TCPStringReader
extends Thread {
    private static final int MESSAGE_BUFFER_SIZE = 65535;
    private static final Logger LOGGER = LoggerFactory.getLogger(TCPStringReader.class);
    private final int port;
    private final ReaderRegistry<String> stringRegistry;
    private volatile boolean terminated;
    private volatile Thread readerThread;

    public TCPStringReader(int port, ReaderRegistry<String> stringRegistry) {
        this.port = port;
        this.stringRegistry = stringRegistry;
    }

    public void terminate() {
        this.terminated = true;
        this.readerThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.readerThread = Thread.currentThread();
        ServerSocketChannel serversocket = null;
        try {
            serversocket = ServerSocketChannel.open();
            serversocket.socket().bind(new InetSocketAddress(this.port));
            LOGGER.debug("Listening on port {}", (Object)this.port);
            SocketChannel socketChannel = serversocket.accept();
            ByteBuffer buffer = ByteBuffer.allocateDirect(65535);
            while (socketChannel.read(buffer) != -1 && !this.terminated) {
                buffer.flip();
                try {
                    while (buffer.hasRemaining()) {
                        buffer.mark();
                        RegistryRecord.registerRecordInRegistry(buffer, this.stringRegistry);
                    }
                    buffer.clear();
                }
                catch (BufferUnderflowException ex) {
                    buffer.reset();
                    buffer.compact();
                }
            }
            socketChannel.close();
        }
        catch (ClosedByInterruptException ex) {
            LOGGER.warn("Reader interrupted", ex);
        }
        catch (IOException ex) {
            LOGGER.error("Error while reading", ex);
        }
        finally {
            if (null != serversocket) {
                try {
                    serversocket.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Failed to close TCP connection!", e);
                }
            }
        }
    }
}

